/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBfdEndpointState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBfdState;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBfdEndpointStateSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBfdStateVer14
implements OFBsnTlvBfdState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBfdStateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnBfdEndpointState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvBfdStateVer14Funnel FUNNEL = new OFBsnTlvBfdStateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBfdStateVer14(OFBsnBfdEndpointState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBfdStateVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 177;
    }

    @Override
    public OFBsnBfdEndpointState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvBfdState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBfdStateVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBfdStateVer14 other = (OFBsnTlvBfdStateVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBfdStateVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBfdStateVer14 message) {
            bb.writeShort(177);
            bb.writeShort(5);
            OFBsnBfdEndpointStateSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvBfdStateVer14Funnel
    implements Funnel<OFBsnTlvBfdStateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBfdStateVer14Funnel() {
        }

        public void funnel(OFBsnTlvBfdStateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)177);
            sink.putShort((short)5);
            OFBsnBfdEndpointStateSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBfdState> {
        Reader() {
        }

        @Override
        public OFBsnTlvBfdState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 177) {
                throw new OFParseError("Wrong type: Expected=0xb1(0xb1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnBfdEndpointState value = OFBsnBfdEndpointStateSerializerVer14.readFrom(bb);
            OFBsnTlvBfdStateVer14 bsnTlvBfdStateVer14 = new OFBsnTlvBfdStateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBfdStateVer14);
            }
            return bsnTlvBfdStateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvBfdState.Builder {
        private boolean valueSet;
        private OFBsnBfdEndpointState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 177;
        }

        @Override
        public OFBsnBfdEndpointState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdState.Builder setValue(OFBsnBfdEndpointState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBfdState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdStateVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBfdState.Builder {
        final OFBsnTlvBfdStateVer14 parentMessage;
        private boolean valueSet;
        private OFBsnBfdEndpointState value;

        BuilderWithParent(OFBsnTlvBfdStateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 177;
        }

        @Override
        public OFBsnBfdEndpointState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdState.Builder setValue(OFBsnBfdEndpointState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBfdState build() {
            OFBsnBfdEndpointState value;
            OFBsnBfdEndpointState oFBsnBfdEndpointState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdStateVer14(value);
        }
    }
}

