/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnImageDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsReplyFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnImageDescStatsReplyVer14
implements OFBsnImageDescStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnImageDescStatsReplyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 536;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final String DEFAULT_IMAGE_CHECKSUM = "";
    private static final String DEFAULT_STARTUP_CONFIG_CHECKSUM = "";
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final String imageChecksum;
    private final String startupConfigChecksum;
    static final OFBsnImageDescStatsReplyVer14 DEFAULT = new OFBsnImageDescStatsReplyVer14(0L, DEFAULT_FLAGS, "", "");
    static final Reader READER = new Reader();
    static final OFBsnImageDescStatsReplyVer14Funnel FUNNEL = new OFBsnImageDescStatsReplyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnImageDescStatsReplyVer14(long xid, Set<OFStatsReplyFlags> flags, String imageChecksum, String startupConfigChecksum) {
        if (flags == null) {
            throw new NullPointerException("OFBsnImageDescStatsReplyVer14: property flags cannot be null");
        }
        if (imageChecksum == null) {
            throw new NullPointerException("OFBsnImageDescStatsReplyVer14: property imageChecksum cannot be null");
        }
        if (startupConfigChecksum == null) {
            throw new NullPointerException("OFBsnImageDescStatsReplyVer14: property startupConfigChecksum cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.imageChecksum = imageChecksum;
        this.startupConfigChecksum = startupConfigChecksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 14L;
    }

    @Override
    public String getImageChecksum() {
        return this.imageChecksum;
    }

    @Override
    public String getStartupConfigChecksum() {
        return this.startupConfigChecksum;
    }

    @Override
    public OFBsnImageDescStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnImageDescStatsReplyVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("imageChecksum=").append(this.imageChecksum);
        b.append(", ");
        b.append("startupConfigChecksum=").append(this.startupConfigChecksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnImageDescStatsReplyVer14 other = (OFBsnImageDescStatsReplyVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.imageChecksum == null ? other.imageChecksum != null : !this.imageChecksum.equals(other.imageChecksum)) {
            return false;
        }
        return !(this.startupConfigChecksum == null ? other.startupConfigChecksum != null : !this.startupConfigChecksum.equals(other.startupConfigChecksum));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnImageDescStatsReplyVer14 other = (OFBsnImageDescStatsReplyVer14)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.imageChecksum == null ? other.imageChecksum != null : !this.imageChecksum.equals(other.imageChecksum)) {
            return false;
        }
        return !(this.startupConfigChecksum == null ? other.startupConfigChecksum != null : !this.startupConfigChecksum.equals(other.startupConfigChecksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.imageChecksum == null ? 0 : this.imageChecksum.hashCode());
        result = 31 * result + (this.startupConfigChecksum == null ? 0 : this.startupConfigChecksum.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.imageChecksum == null ? 0 : this.imageChecksum.hashCode());
        result = 31 * result + (this.startupConfigChecksum == null ? 0 : this.startupConfigChecksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnImageDescStatsReplyVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnImageDescStatsReplyVer14 message) {
            bb.writeByte(5);
            bb.writeByte(19);
            bb.writeShort(536);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsReplyFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(14);
            ChannelUtils.writeFixedLengthString(bb, message.imageChecksum, 256);
            ChannelUtils.writeFixedLengthString(bb, message.startupConfigChecksum, 256);
        }
    }

    static class OFBsnImageDescStatsReplyVer14Funnel
    implements Funnel<OFBsnImageDescStatsReplyVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnImageDescStatsReplyVer14Funnel() {
        }

        public void funnel(OFBsnImageDescStatsReplyVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)19);
            sink.putShort((short)536);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsReplyFlagsSerializerVer14.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(14);
            sink.putUnencodedChars((CharSequence)message.imageChecksum);
            sink.putUnencodedChars((CharSequence)message.startupConfigChecksum);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnImageDescStatsReply> {
        Reader() {
        }

        @Override
        public OFBsnImageDescStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 536) {
                throw new OFParseError("Wrong length: Expected=536(536), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 14) {
                throw new OFParseError("Wrong subtype: Expected=0xeL(0xeL), got=" + subtype);
            }
            String imageChecksum = ChannelUtils.readFixedLengthString(bb, 256);
            String startupConfigChecksum = ChannelUtils.readFixedLengthString(bb, 256);
            OFBsnImageDescStatsReplyVer14 bsnImageDescStatsReplyVer14 = new OFBsnImageDescStatsReplyVer14(xid, flags, imageChecksum, startupConfigChecksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnImageDescStatsReplyVer14);
            }
            return bsnImageDescStatsReplyVer14;
        }
    }

    static class Builder
    implements OFBsnImageDescStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean imageChecksumSet;
        private String imageChecksum;
        private boolean startupConfigChecksumSet;
        private String startupConfigChecksum;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 14L;
        }

        @Override
        public String getImageChecksum() {
            return this.imageChecksum;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setImageChecksum(String imageChecksum) {
            this.imageChecksum = imageChecksum;
            this.imageChecksumSet = true;
            return this;
        }

        @Override
        public String getStartupConfigChecksum() {
            return this.startupConfigChecksum;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setStartupConfigChecksum(String startupConfigChecksum) {
            this.startupConfigChecksum = startupConfigChecksum;
            this.startupConfigChecksumSet = true;
            return this;
        }

        @Override
        public OFBsnImageDescStatsReply build() {
            String startupConfigChecksum;
            String imageChecksum;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = imageChecksum = this.imageChecksumSet ? this.imageChecksum : "";
            if (imageChecksum == null) {
                throw new NullPointerException("Property imageChecksum must not be null");
            }
            String string2 = startupConfigChecksum = this.startupConfigChecksumSet ? this.startupConfigChecksum : "";
            if (startupConfigChecksum == null) {
                throw new NullPointerException("Property startupConfigChecksum must not be null");
            }
            return new OFBsnImageDescStatsReplyVer14(xid, flags, imageChecksum, startupConfigChecksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnImageDescStatsReply.Builder {
        final OFBsnImageDescStatsReplyVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean imageChecksumSet;
        private String imageChecksum;
        private boolean startupConfigChecksumSet;
        private String startupConfigChecksum;

        BuilderWithParent(OFBsnImageDescStatsReplyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 14L;
        }

        @Override
        public String getImageChecksum() {
            return this.imageChecksum;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setImageChecksum(String imageChecksum) {
            this.imageChecksum = imageChecksum;
            this.imageChecksumSet = true;
            return this;
        }

        @Override
        public String getStartupConfigChecksum() {
            return this.startupConfigChecksum;
        }

        @Override
        public OFBsnImageDescStatsReply.Builder setStartupConfigChecksum(String startupConfigChecksum) {
            this.startupConfigChecksum = startupConfigChecksum;
            this.startupConfigChecksumSet = true;
            return this;
        }

        @Override
        public OFBsnImageDescStatsReply build() {
            String startupConfigChecksum;
            String imageChecksum;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = imageChecksum = this.imageChecksumSet ? this.imageChecksum : this.parentMessage.imageChecksum;
            if (imageChecksum == null) {
                throw new NullPointerException("Property imageChecksum must not be null");
            }
            String string2 = startupConfigChecksum = this.startupConfigChecksumSet ? this.startupConfigChecksum : this.parentMessage.startupConfigChecksum;
            if (startupConfigChecksum == null) {
                throw new NullPointerException("Property startupConfigChecksum must not be null");
            }
            return new OFBsnImageDescStatsReplyVer14(xid, flags, imageChecksum, startupConfigChecksum);
        }
    }
}

