/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropTableStatusMaster;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropTableStatusMasterVer14
implements OFAsyncConfigPropTableStatusMaster {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropTableStatusMasterVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropTableStatusMasterVer14 DEFAULT = new OFAsyncConfigPropTableStatusMasterVer14(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropTableStatusMasterVer14Funnel FUNNEL = new OFAsyncConfigPropTableStatusMasterVer14Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropTableStatusMasterVer14(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFAsyncConfigPropTableStatusMaster.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropTableStatusMasterVer14(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropTableStatusMasterVer14 other = (OFAsyncConfigPropTableStatusMasterVer14)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropTableStatusMasterVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropTableStatusMasterVer14 message) {
            bb.writeShort(9);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropTableStatusMasterVer14Funnel
    implements Funnel<OFAsyncConfigPropTableStatusMasterVer14> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropTableStatusMasterVer14Funnel() {
        }

        public void funnel(OFAsyncConfigPropTableStatusMasterVer14 message, PrimitiveSink sink) {
            sink.putShort((short)9);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropTableStatusMaster> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropTableStatusMaster readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 9) {
                throw new OFParseError("Wrong type: Expected=0x9(0x9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropTableStatusMasterVer14 asyncConfigPropTableStatusMasterVer14 = new OFAsyncConfigPropTableStatusMasterVer14(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropTableStatusMasterVer14);
            }
            return asyncConfigPropTableStatusMasterVer14;
        }
    }

    static class Builder
    implements OFAsyncConfigPropTableStatusMaster.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropTableStatusMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropTableStatusMaster build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropTableStatusMasterVer14(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropTableStatusMaster.Builder {
        final OFAsyncConfigPropTableStatusMasterVer14 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropTableStatusMasterVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 9;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropTableStatusMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropTableStatusMaster build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropTableStatusMasterVer14(mask);
        }
    }
}

