/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropRequestforwardMaster;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropRequestforwardMasterVer14
implements OFAsyncConfigPropRequestforwardMaster {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropRequestforwardMasterVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropRequestforwardMasterVer14 DEFAULT = new OFAsyncConfigPropRequestforwardMasterVer14(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropRequestforwardMasterVer14Funnel FUNNEL = new OFAsyncConfigPropRequestforwardMasterVer14Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropRequestforwardMasterVer14(long mask) {
        this.mask = mask;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFAsyncConfigPropRequestforwardMaster.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropRequestforwardMasterVer14(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropRequestforwardMasterVer14 other = (OFAsyncConfigPropRequestforwardMasterVer14)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropRequestforwardMasterVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropRequestforwardMasterVer14 message) {
            bb.writeShort(11);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropRequestforwardMasterVer14Funnel
    implements Funnel<OFAsyncConfigPropRequestforwardMasterVer14> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropRequestforwardMasterVer14Funnel() {
        }

        public void funnel(OFAsyncConfigPropRequestforwardMasterVer14 message, PrimitiveSink sink) {
            sink.putShort((short)11);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropRequestforwardMaster> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropRequestforwardMaster readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=0xb(0xb), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropRequestforwardMasterVer14 asyncConfigPropRequestforwardMasterVer14 = new OFAsyncConfigPropRequestforwardMasterVer14(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropRequestforwardMasterVer14);
            }
            return asyncConfigPropRequestforwardMasterVer14;
        }
    }

    static class Builder
    implements OFAsyncConfigPropRequestforwardMaster.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 11;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRequestforwardMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropRequestforwardMaster build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropRequestforwardMasterVer14(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropRequestforwardMaster.Builder {
        final OFAsyncConfigPropRequestforwardMasterVer14 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropRequestforwardMasterVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 11;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropRequestforwardMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFAsyncConfigPropRequestforwardMaster build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropRequestforwardMasterVer14(mask);
        }
    }
}

