/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdDecNwTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdDecNwTtlVer14
implements OFActionIdDecNwTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdDecNwTtlVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 4;
    static final OFActionIdDecNwTtlVer14 DEFAULT = new OFActionIdDecNwTtlVer14();
    static final OFActionIdDecNwTtlVer14 INSTANCE = new OFActionIdDecNwTtlVer14();
    static final Reader READER = new Reader();
    static final OFActionIdDecNwTtlVer14Funnel FUNNEL = new OFActionIdDecNwTtlVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdDecNwTtlVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.DEC_NW_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionIdDecNwTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdDecNwTtlVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdDecNwTtlVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdDecNwTtlVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdDecNwTtlVer14 message) {
            bb.writeShort(24);
            bb.writeShort(4);
        }
    }

    static class OFActionIdDecNwTtlVer14Funnel
    implements Funnel<OFActionIdDecNwTtlVer14> {
        private static final long serialVersionUID = 1L;

        OFActionIdDecNwTtlVer14Funnel() {
        }

        public void funnel(OFActionIdDecNwTtlVer14 message, PrimitiveSink sink) {
            sink.putShort((short)24);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdDecNwTtl> {
        Reader() {
        }

        @Override
        public OFActionIdDecNwTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 24) {
                throw new OFParseError("Wrong type: Expected=OFActionType.DEC_NW_TTL(24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

