/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunnelIpv4Src;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunnelIpv4SrcVer13
implements OFOxmTunnelIpv4Src {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunnelIpv4SrcVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFOxmTunnelIpv4SrcVer13 DEFAULT = new OFOxmTunnelIpv4SrcVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunnelIpv4SrcVer13Funnel FUNNEL = new OFOxmTunnelIpv4SrcVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunnelIpv4SrcVer13(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunnelIpv4SrcVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 81412L;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv4Address> getMatchField() {
        return MatchField.TUNNEL_IPV4_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv4Address> getCanonical() {
        return this;
    }

    @Override
    public IPv4Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmTunnelIpv4Src.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunnelIpv4SrcVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunnelIpv4SrcVer13 other = (OFOxmTunnelIpv4SrcVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunnelIpv4SrcVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmTunnelIpv4SrcVer13 message) {
            bb.writeInt(81412);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmTunnelIpv4SrcVer13Funnel
    implements Funnel<OFOxmTunnelIpv4SrcVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmTunnelIpv4SrcVer13Funnel() {
        }

        public void funnel(OFOxmTunnelIpv4SrcVer13 message, PrimitiveSink sink) {
            sink.putInt(81412);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunnelIpv4Src> {
        Reader() {
        }

        @Override
        public OFOxmTunnelIpv4Src readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 81412) {
                throw new OFParseError("Wrong typeLen: Expected=0x13e04L(0x13e04L), got=" + typeLen);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFOxmTunnelIpv4SrcVer13 oxmTunnelIpv4SrcVer13 = new OFOxmTunnelIpv4SrcVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunnelIpv4SrcVer13);
            }
            return oxmTunnelIpv4SrcVer13;
        }
    }

    static class Builder
    implements OFOxmTunnelIpv4Src.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 81412L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelIpv4Src.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.TUNNEL_IPV4_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTunnelIpv4Src build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIpv4SrcVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunnelIpv4Src.Builder {
        final OFOxmTunnelIpv4SrcVer13 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFOxmTunnelIpv4SrcVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 81412L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunnelIpv4Src.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.TUNNEL_IPV4_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmTunnelIpv4Src build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunnelIpv4SrcVer13(value);
        }
    }
}

