/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6Src;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6SrcVer13
implements OFOxmIpv6Src {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6SrcVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 20;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private final IPv6Address value;
    static final OFOxmIpv6SrcVer13 DEFAULT = new OFOxmIpv6SrcVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpv6SrcVer13Funnel FUNNEL = new OFOxmIpv6SrcVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6SrcVer13(IPv6Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6SrcVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147496976L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.IPV6_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        return this;
    }

    @Override
    public IPv6Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmIpv6Src.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6SrcVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6SrcVer13 other = (OFOxmIpv6SrcVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6SrcVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpv6SrcVer13 message) {
            bb.writeInt(-2147470320);
            message.value.write16Bytes(bb);
        }
    }

    static class OFOxmIpv6SrcVer13Funnel
    implements Funnel<OFOxmIpv6SrcVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6SrcVer13Funnel() {
        }

        public void funnel(OFOxmIpv6SrcVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147470320);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6Src> {
        Reader() {
        }

        @Override
        public OFOxmIpv6Src readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147470320) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003410L(0x80003410L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            OFOxmIpv6SrcVer13 oxmIpv6SrcVer13 = new OFOxmIpv6SrcVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6SrcVer13);
            }
            return oxmIpv6SrcVer13;
        }
    }

    static class Builder
    implements OFOxmIpv6Src.Builder {
        private boolean valueSet;
        private IPv6Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147496976L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Src.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IPv6Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIpv6Src build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6SrcVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6Src.Builder {
        final OFOxmIpv6SrcVer13 parentMessage;
        private boolean valueSet;
        private IPv6Address value;

        BuilderWithParent(OFOxmIpv6SrcVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147496976L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Src.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public IPv6Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIpv6Src build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6SrcVer13(value);
        }
    }
}

