/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmInPhyPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmInPhyPortVer13
implements OFOxmInPhyPort {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmInPhyPortVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFOxmInPhyPortVer13 DEFAULT = new OFOxmInPhyPortVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmInPhyPortVer13Funnel FUNNEL = new OFOxmInPhyPortVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmInPhyPortVer13(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmInPhyPortVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147484164L;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<OFPort> getMatchField() {
        return MatchField.IN_PHY_PORT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OFPort> getCanonical() {
        return this;
    }

    @Override
    public OFPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmInPhyPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmInPhyPortVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmInPhyPortVer13 other = (OFOxmInPhyPortVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmInPhyPortVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmInPhyPortVer13 message) {
            bb.writeInt(-2147483132);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmInPhyPortVer13Funnel
    implements Funnel<OFOxmInPhyPortVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmInPhyPortVer13Funnel() {
        }

        public void funnel(OFOxmInPhyPortVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147483132);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmInPhyPort> {
        Reader() {
        }

        @Override
        public OFOxmInPhyPort readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147483132) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000204L(0x80000204L), got=" + typeLen);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFOxmInPhyPortVer13 oxmInPhyPortVer13 = new OFOxmInPhyPortVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmInPhyPortVer13);
            }
            return oxmInPhyPortVer13;
        }
    }

    static class Builder
    implements OFOxmInPhyPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147484164L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPhyPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PHY_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmInPhyPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmInPhyPortVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmInPhyPort.Builder {
        final OFOxmInPhyPortVer13 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFOxmInPhyPortVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147484164L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPhyPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PHY_PORT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmInPhyPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmInPhyPortVer13(value);
        }
    }
}

