/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv4Type;
import org.projectfloodlight.openflow.types.ICMPv4Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv4TypeVer13
implements OFOxmIcmpv4Type {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv4TypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final ICMPv4Type DEFAULT_VALUE = ICMPv4Type.NONE;
    private final ICMPv4Type value;
    static final OFOxmIcmpv4TypeVer13 DEFAULT = new OFOxmIcmpv4TypeVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv4TypeVer13Funnel FUNNEL = new OFOxmIcmpv4TypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv4TypeVer13(ICMPv4Type value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIcmpv4TypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147493377L;
    }

    @Override
    public ICMPv4Type getValue() {
        return this.value;
    }

    @Override
    public MatchField<ICMPv4Type> getMatchField() {
        return MatchField.ICMPV4_TYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ICMPv4Type> getCanonical() {
        return this;
    }

    @Override
    public ICMPv4Type getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmIcmpv4Type.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv4TypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv4TypeVer13 other = (OFOxmIcmpv4TypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv4TypeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIcmpv4TypeVer13 message) {
            bb.writeInt(-2147473919);
            message.value.writeByte(bb);
        }
    }

    static class OFOxmIcmpv4TypeVer13Funnel
    implements Funnel<OFOxmIcmpv4TypeVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv4TypeVer13Funnel() {
        }

        public void funnel(OFOxmIcmpv4TypeVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147473919);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv4Type> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv4Type readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147473919) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002601L(0x80002601L), got=" + typeLen);
            }
            ICMPv4Type value = ICMPv4Type.readByte(bb);
            OFOxmIcmpv4TypeVer13 oxmIcmpv4TypeVer13 = new OFOxmIcmpv4TypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv4TypeVer13);
            }
            return oxmIcmpv4TypeVer13;
        }
    }

    static class Builder
    implements OFOxmIcmpv4Type.Builder {
        private boolean valueSet;
        private ICMPv4Type value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147493377L;
        }

        @Override
        public ICMPv4Type getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4Type.Builder setValue(ICMPv4Type value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Type> getMatchField() {
            return MatchField.ICMPV4_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ICMPv4Type> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public ICMPv4Type getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIcmpv4Type build() {
            ICMPv4Type value;
            ICMPv4Type iCMPv4Type = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv4TypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv4Type.Builder {
        final OFOxmIcmpv4TypeVer13 parentMessage;
        private boolean valueSet;
        private ICMPv4Type value;

        BuilderWithParent(OFOxmIcmpv4TypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147493377L;
        }

        @Override
        public ICMPv4Type getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4Type.Builder setValue(ICMPv4Type value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Type> getMatchField() {
            return MatchField.ICMPV4_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ICMPv4Type> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public ICMPv4Type getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIcmpv4Type build() {
            ICMPv4Type value;
            ICMPv4Type iCMPv4Type = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIcmpv4TypeVer13(value);
        }
    }
}

