/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnL3SrcClassId;
import org.projectfloodlight.openflow.types.ClassId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnL3SrcClassIdVer13
implements OFOxmBsnL3SrcClassId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnL3SrcClassIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final ClassId DEFAULT_VALUE = ClassId.NONE;
    private final ClassId value;
    static final OFOxmBsnL3SrcClassIdVer13 DEFAULT = new OFOxmBsnL3SrcClassIdVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnL3SrcClassIdVer13Funnel FUNNEL = new OFOxmBsnL3SrcClassIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnL3SrcClassIdVer13(ClassId value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnL3SrcClassIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 199172L;
    }

    @Override
    public ClassId getValue() {
        return this.value;
    }

    @Override
    public MatchField<ClassId> getMatchField() {
        return MatchField.BSN_L3_SRC_CLASS_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ClassId> getCanonical() {
        return this;
    }

    @Override
    public ClassId getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnL3SrcClassId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnL3SrcClassIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnL3SrcClassIdVer13 other = (OFOxmBsnL3SrcClassIdVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnL3SrcClassIdVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnL3SrcClassIdVer13 message) {
            bb.writeInt(199172);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnL3SrcClassIdVer13Funnel
    implements Funnel<OFOxmBsnL3SrcClassIdVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnL3SrcClassIdVer13Funnel() {
        }

        public void funnel(OFOxmBsnL3SrcClassIdVer13 message, PrimitiveSink sink) {
            sink.putInt(199172);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnL3SrcClassId> {
        Reader() {
        }

        @Override
        public OFOxmBsnL3SrcClassId readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 199172) {
                throw new OFParseError("Wrong typeLen: Expected=0x30a04L(0x30a04L), got=" + typeLen);
            }
            ClassId value = ClassId.read4Bytes(bb);
            OFOxmBsnL3SrcClassIdVer13 oxmBsnL3SrcClassIdVer13 = new OFOxmBsnL3SrcClassIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnL3SrcClassIdVer13);
            }
            return oxmBsnL3SrcClassIdVer13;
        }
    }

    static class Builder
    implements OFOxmBsnL3SrcClassId.Builder {
        private boolean valueSet;
        private ClassId value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 199172L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnL3SrcClassId.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_L3_SRC_CLASS_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public ClassId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnL3SrcClassId build() {
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnL3SrcClassIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnL3SrcClassId.Builder {
        final OFOxmBsnL3SrcClassIdVer13 parentMessage;
        private boolean valueSet;
        private ClassId value;

        BuilderWithParent(OFOxmBsnL3SrcClassIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 199172L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnL3SrcClassId.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_L3_SRC_CLASS_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public ClassId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnL3SrcClassId build() {
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnL3SrcClassIdVer13(value);
        }
    }
}

