/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBandExperimenter;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterBandExperimenterVer13
implements OFMeterBandExperimenter {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterBandExperimenterVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_RATE = 0L;
    private static final long DEFAULT_BURST_SIZE = 0L;
    private static final long DEFAULT_EXPERIMENTER = 0L;
    private final long rate;
    private final long burstSize;
    private final long experimenter;
    static final OFMeterBandExperimenterVer13 DEFAULT = new OFMeterBandExperimenterVer13(0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFMeterBandExperimenterVer13Funnel FUNNEL = new OFMeterBandExperimenterVer13Funnel();
    static final Writer WRITER = new Writer();

    OFMeterBandExperimenterVer13(long rate, long burstSize, long experimenter) {
        this.rate = rate;
        this.burstSize = burstSize;
        this.experimenter = experimenter;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getRate() {
        return this.rate;
    }

    @Override
    public long getBurstSize() {
        return this.burstSize;
    }

    @Override
    public long getExperimenter() {
        return this.experimenter;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFMeterBandExperimenter.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterBandExperimenterVer13(");
        b.append("rate=").append(this.rate);
        b.append(", ");
        b.append("burstSize=").append(this.burstSize);
        b.append(", ");
        b.append("experimenter=").append(this.experimenter);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterBandExperimenterVer13 other = (OFMeterBandExperimenterVer13)obj;
        if (this.rate != other.rate) {
            return false;
        }
        if (this.burstSize != other.burstSize) {
            return false;
        }
        return this.experimenter == other.experimenter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.rate ^ this.rate >>> 32);
        result = 31 * (int)(this.burstSize ^ this.burstSize >>> 32);
        result = 31 * (int)(this.experimenter ^ this.experimenter >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterBandExperimenterVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterBandExperimenterVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.rate));
            bb.writeInt(U32.t(message.burstSize));
            bb.writeInt(U32.t(message.experimenter));
        }
    }

    static class OFMeterBandExperimenterVer13Funnel
    implements Funnel<OFMeterBandExperimenterVer13> {
        private static final long serialVersionUID = 1L;

        OFMeterBandExperimenterVer13Funnel() {
        }

        public void funnel(OFMeterBandExperimenterVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putLong(message.rate);
            sink.putLong(message.burstSize);
            sink.putLong(message.experimenter);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterBandExperimenter> {
        Reader() {
        }

        @Override
        public OFMeterBandExperimenter readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long rate = U32.f(bb.readInt());
            long burstSize = U32.f(bb.readInt());
            long experimenter = U32.f(bb.readInt());
            OFMeterBandExperimenterVer13 meterBandExperimenterVer13 = new OFMeterBandExperimenterVer13(rate, burstSize, experimenter);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterBandExperimenterVer13);
            }
            return meterBandExperimenterVer13;
        }
    }

    static class Builder
    implements OFMeterBandExperimenter.Builder {
        private boolean rateSet;
        private long rate;
        private boolean burstSizeSet;
        private long burstSize;
        private boolean experimenterSet;
        private long experimenter;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getRate() {
            return this.rate;
        }

        @Override
        public OFMeterBandExperimenter.Builder setRate(long rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public long getBurstSize() {
            return this.burstSize;
        }

        @Override
        public OFMeterBandExperimenter.Builder setBurstSize(long burstSize) {
            this.burstSize = burstSize;
            this.burstSizeSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return this.experimenter;
        }

        @Override
        public OFMeterBandExperimenter.Builder setExperimenter(long experimenter) {
            this.experimenter = experimenter;
            this.experimenterSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFMeterBandExperimenter build() {
            long rate = this.rateSet ? this.rate : 0L;
            long burstSize = this.burstSizeSet ? this.burstSize : 0L;
            long experimenter = this.experimenterSet ? this.experimenter : 0L;
            return new OFMeterBandExperimenterVer13(rate, burstSize, experimenter);
        }
    }

    static class BuilderWithParent
    implements OFMeterBandExperimenter.Builder {
        final OFMeterBandExperimenterVer13 parentMessage;
        private boolean rateSet;
        private long rate;
        private boolean burstSizeSet;
        private long burstSize;
        private boolean experimenterSet;
        private long experimenter;

        BuilderWithParent(OFMeterBandExperimenterVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getRate() {
            return this.rate;
        }

        @Override
        public OFMeterBandExperimenter.Builder setRate(long rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public long getBurstSize() {
            return this.burstSize;
        }

        @Override
        public OFMeterBandExperimenter.Builder setBurstSize(long burstSize) {
            this.burstSize = burstSize;
            this.burstSizeSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return this.experimenter;
        }

        @Override
        public OFMeterBandExperimenter.Builder setExperimenter(long experimenter) {
            this.experimenter = experimenter;
            this.experimenterSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFMeterBandExperimenter build() {
            long rate = this.rateSet ? this.rate : this.parentMessage.rate;
            long burstSize = this.burstSizeSet ? this.burstSize : this.parentMessage.burstSize;
            long experimenter = this.experimenterSet ? this.experimenter : this.parentMessage.experimenter;
            return new OFMeterBandExperimenterVer13(rate, burstSize, experimenter);
        }
    }
}

