/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVlanMac;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVlanMacVer13
implements OFBsnVlanMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVlanMacVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final int DEFAULT_VLAN_VID = 0;
    private static final MacAddress DEFAULT_MAC = MacAddress.NONE;
    private final int vlanVid;
    private final MacAddress mac;
    static final OFBsnVlanMacVer13 DEFAULT = new OFBsnVlanMacVer13(0, DEFAULT_MAC);
    static final Reader READER = new Reader();
    static final OFBsnVlanMacVer13Funnel FUNNEL = new OFBsnVlanMacVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVlanMacVer13(int vlanVid, MacAddress mac) {
        if (mac == null) {
            throw new NullPointerException("OFBsnVlanMacVer13: property mac cannot be null");
        }
        this.vlanVid = vlanVid;
        this.mac = mac;
    }

    @Override
    public int getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public MacAddress getMac() {
        return this.mac;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnVlanMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVlanMacVer13(");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(", ");
        b.append("mac=").append(this.mac);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVlanMacVer13 other = (OFBsnVlanMacVer13)obj;
        if (this.vlanVid != other.vlanVid) {
            return false;
        }
        return !(this.mac == null ? other.mac != null : !this.mac.equals(other.mac));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vlanVid;
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVlanMacVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVlanMacVer13 message) {
            bb.writeShort((int)U16.t(message.vlanVid));
            message.mac.write6Bytes(bb);
        }
    }

    static class OFBsnVlanMacVer13Funnel
    implements Funnel<OFBsnVlanMacVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVlanMacVer13Funnel() {
        }

        public void funnel(OFBsnVlanMacVer13 message, PrimitiveSink sink) {
            sink.putInt(message.vlanVid);
            message.mac.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVlanMac> {
        Reader() {
        }

        @Override
        public OFBsnVlanMac readFrom(ByteBuf bb) throws OFParseError {
            int vlanVid = U16.f(bb.readShort());
            MacAddress mac = MacAddress.read6Bytes(bb);
            OFBsnVlanMacVer13 bsnVlanMacVer13 = new OFBsnVlanMacVer13(vlanVid, mac);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVlanMacVer13);
            }
            return bsnVlanMacVer13;
        }
    }

    static class Builder
    implements OFBsnVlanMac.Builder {
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean macSet;
        private MacAddress mac;

        Builder() {
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanMac.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public MacAddress getMac() {
            return this.mac;
        }

        @Override
        public OFBsnVlanMac.Builder setMac(MacAddress mac) {
            this.mac = mac;
            this.macSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnVlanMac build() {
            MacAddress mac;
            int vlanVid = this.vlanVidSet ? this.vlanVid : 0;
            MacAddress macAddress = mac = this.macSet ? this.mac : DEFAULT_MAC;
            if (mac == null) {
                throw new NullPointerException("Property mac must not be null");
            }
            return new OFBsnVlanMacVer13(vlanVid, mac);
        }
    }

    static class BuilderWithParent
    implements OFBsnVlanMac.Builder {
        final OFBsnVlanMacVer13 parentMessage;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean macSet;
        private MacAddress mac;

        BuilderWithParent(OFBsnVlanMacVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFBsnVlanMac.Builder setVlanVid(int vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public MacAddress getMac() {
            return this.mac;
        }

        @Override
        public OFBsnVlanMac.Builder setMac(MacAddress mac) {
            this.mac = mac;
            this.macSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnVlanMac build() {
            MacAddress mac;
            int vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            MacAddress macAddress = mac = this.macSet ? this.mac : this.parentMessage.mac;
            if (mac == null) {
                throw new NullPointerException("Property mac must not be null");
            }
            return new OFBsnVlanMacVer13(vlanVid, mac);
        }
    }
}

