/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVirtualPortCreateRequest;
import org.projectfloodlight.openflow.protocol.OFBsnVport;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnVportVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVirtualPortCreateRequestVer13
implements OFBsnVirtualPortCreateRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVirtualPortCreateRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFBsnVport vport;
    static final Reader READER = new Reader();
    static final OFBsnVirtualPortCreateRequestVer13Funnel FUNNEL = new OFBsnVirtualPortCreateRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVirtualPortCreateRequestVer13(long xid, OFBsnVport vport) {
        if (vport == null) {
            throw new NullPointerException("OFBsnVirtualPortCreateRequestVer13: property vport cannot be null");
        }
        this.xid = xid;
        this.vport = vport;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 15L;
    }

    @Override
    public OFBsnVport getVport() {
        return this.vport;
    }

    @Override
    public OFBsnVirtualPortCreateRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVirtualPortCreateRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("vport=").append(this.vport);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVirtualPortCreateRequestVer13 other = (OFBsnVirtualPortCreateRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.vport == null ? other.vport != null : !this.vport.equals(other.vport));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVirtualPortCreateRequestVer13 other = (OFBsnVirtualPortCreateRequestVer13)obj;
        return !(this.vport == null ? other.vport != null : !this.vport.equals(other.vport));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.vport == null ? 0 : this.vport.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vport == null ? 0 : this.vport.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVirtualPortCreateRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVirtualPortCreateRequestVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(15);
            message.vport.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnVirtualPortCreateRequestVer13Funnel
    implements Funnel<OFBsnVirtualPortCreateRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVirtualPortCreateRequestVer13Funnel() {
        }

        public void funnel(OFBsnVirtualPortCreateRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(15);
            message.vport.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVirtualPortCreateRequest> {
        Reader() {
        }

        @Override
        public OFBsnVirtualPortCreateRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 20) {
                throw new OFParseError("Wrong length: Expected to be >= 20, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 15) {
                throw new OFParseError("Wrong subtype: Expected=0xfL(0xfL), got=" + subtype);
            }
            OFBsnVport vport = OFBsnVportVer13.READER.readFrom(bb);
            OFBsnVirtualPortCreateRequestVer13 bsnVirtualPortCreateRequestVer13 = new OFBsnVirtualPortCreateRequestVer13(xid, vport);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVirtualPortCreateRequestVer13);
            }
            return bsnVirtualPortCreateRequestVer13;
        }
    }

    static class Builder
    implements OFBsnVirtualPortCreateRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean vportSet;
        private OFBsnVport vport;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVirtualPortCreateRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 15L;
        }

        @Override
        public OFBsnVport getVport() {
            return this.vport;
        }

        @Override
        public OFBsnVirtualPortCreateRequest.Builder setVport(OFBsnVport vport) {
            this.vport = vport;
            this.vportSet = true;
            return this;
        }

        @Override
        public OFBsnVirtualPortCreateRequest build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.vportSet) {
                throw new IllegalStateException("Property vport doesn't have default value -- must be set");
            }
            if (this.vport == null) {
                throw new NullPointerException("Property vport must not be null");
            }
            return new OFBsnVirtualPortCreateRequestVer13(xid, this.vport);
        }
    }

    static class BuilderWithParent
    implements OFBsnVirtualPortCreateRequest.Builder {
        final OFBsnVirtualPortCreateRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean vportSet;
        private OFBsnVport vport;

        BuilderWithParent(OFBsnVirtualPortCreateRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVirtualPortCreateRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 15L;
        }

        @Override
        public OFBsnVport getVport() {
            return this.vport;
        }

        @Override
        public OFBsnVirtualPortCreateRequest.Builder setVport(OFBsnVport vport) {
            this.vport = vport;
            this.vportSet = true;
            return this;
        }

        @Override
        public OFBsnVirtualPortCreateRequest build() {
            OFBsnVport vport;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBsnVport oFBsnVport = vport = this.vportSet ? this.vport : this.parentMessage.vport;
            if (vport == null) {
                throw new NullPointerException("Property vport must not be null");
            }
            return new OFBsnVirtualPortCreateRequestVer13(xid, vport);
        }
    }
}

