/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVni;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVniVer13
implements OFBsnTlvVni {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVniVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvVniVer13 DEFAULT = new OFBsnTlvVniVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvVniVer13Funnel FUNNEL = new OFBsnTlvVniVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVniVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 86;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvVni.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVniVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVniVer13 other = (OFBsnTlvVniVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVniVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVniVer13 message) {
            bb.writeShort(86);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvVniVer13Funnel
    implements Funnel<OFBsnTlvVniVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVniVer13Funnel() {
        }

        public void funnel(OFBsnTlvVniVer13 message, PrimitiveSink sink) {
            sink.putShort((short)86);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVni> {
        Reader() {
        }

        @Override
        public OFBsnTlvVni readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 86) {
                throw new OFParseError("Wrong type: Expected=0x56(0x56), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvVniVer13 bsnTlvVniVer13 = new OFBsnTlvVniVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVniVer13);
            }
            return bsnTlvVniVer13;
        }
    }

    static class Builder
    implements OFBsnTlvVni.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 86;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVni.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVni build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvVniVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVni.Builder {
        final OFBsnTlvVniVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvVniVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 86;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVni.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVni build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvVniVer13(value);
        }
    }
}

