/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVlanMac;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVlanMacList;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnVlanMacVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVlanMacListVer13
implements OFBsnTlvVlanMacList {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVlanMacListVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFBsnVlanMac> DEFAULT_KEY = ImmutableList.of();
    private final List<OFBsnVlanMac> key;
    static final OFBsnTlvVlanMacListVer13 DEFAULT = new OFBsnTlvVlanMacListVer13(DEFAULT_KEY);
    static final Reader READER = new Reader();
    static final OFBsnTlvVlanMacListVer13Funnel FUNNEL = new OFBsnTlvVlanMacListVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVlanMacListVer13(List<OFBsnVlanMac> key) {
        if (key == null) {
            throw new NullPointerException("OFBsnTlvVlanMacListVer13: property key cannot be null");
        }
        this.key = key;
    }

    @Override
    public int getType() {
        return 98;
    }

    @Override
    public List<OFBsnVlanMac> getKey() {
        return this.key;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvVlanMacList.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVlanMacListVer13(");
        b.append("key=").append(this.key);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVlanMacListVer13 other = (OFBsnTlvVlanMacListVer13)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVlanMacListVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVlanMacListVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(98);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.key);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvVlanMacListVer13Funnel
    implements Funnel<OFBsnTlvVlanMacListVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVlanMacListVer13Funnel() {
        }

        public void funnel(OFBsnTlvVlanMacListVer13 message, PrimitiveSink sink) {
            sink.putShort((short)98);
            FunnelUtils.putList(message.key, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVlanMacList> {
        Reader() {
        }

        @Override
        public OFBsnTlvVlanMacList readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 98) {
                throw new OFParseError("Wrong type: Expected=0x62(0x62), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFBsnVlanMac> key = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnVlanMacVer13.READER);
            OFBsnTlvVlanMacListVer13 bsnTlvVlanMacListVer13 = new OFBsnTlvVlanMacListVer13(key);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVlanMacListVer13);
            }
            return bsnTlvVlanMacListVer13;
        }
    }

    static class Builder
    implements OFBsnTlvVlanMacList.Builder {
        private boolean keySet;
        private List<OFBsnVlanMac> key;

        Builder() {
        }

        @Override
        public int getType() {
            return 98;
        }

        @Override
        public List<OFBsnVlanMac> getKey() {
            return this.key;
        }

        @Override
        public OFBsnTlvVlanMacList.Builder setKey(List<OFBsnVlanMac> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVlanMacList build() {
            List<OFBsnVlanMac> key;
            List<OFBsnVlanMac> list = key = this.keySet ? this.key : DEFAULT_KEY;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            return new OFBsnTlvVlanMacListVer13(key);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVlanMacList.Builder {
        final OFBsnTlvVlanMacListVer13 parentMessage;
        private boolean keySet;
        private List<OFBsnVlanMac> key;

        BuilderWithParent(OFBsnTlvVlanMacListVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 98;
        }

        @Override
        public List<OFBsnVlanMac> getKey() {
            return this.key;
        }

        @Override
        public OFBsnTlvVlanMacList.Builder setKey(List<OFBsnVlanMac> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVlanMacList build() {
            List key;
            List list = key = this.keySet ? this.key : this.parentMessage.key;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            return new OFBsnTlvVlanMacListVer13(key);
        }
    }
}

