/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvInterval;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIntervalVer13
implements OFBsnTlvInterval {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIntervalVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvIntervalVer13 DEFAULT = new OFBsnTlvIntervalVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvIntervalVer13Funnel FUNNEL = new OFBsnTlvIntervalVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIntervalVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 58;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvInterval.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIntervalVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIntervalVer13 other = (OFBsnTlvIntervalVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIntervalVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIntervalVer13 message) {
            bb.writeShort(58);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvIntervalVer13Funnel
    implements Funnel<OFBsnTlvIntervalVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIntervalVer13Funnel() {
        }

        public void funnel(OFBsnTlvIntervalVer13 message, PrimitiveSink sink) {
            sink.putShort((short)58);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvInterval> {
        Reader() {
        }

        @Override
        public OFBsnTlvInterval readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 58) {
                throw new OFParseError("Wrong type: Expected=0x3a(0x3a), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvIntervalVer13 bsnTlvIntervalVer13 = new OFBsnTlvIntervalVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIntervalVer13);
            }
            return bsnTlvIntervalVer13;
        }
    }

    static class Builder
    implements OFBsnTlvInterval.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 58;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvInterval.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvInterval build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvIntervalVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvInterval.Builder {
        final OFBsnTlvIntervalVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvIntervalVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 58;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvInterval.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvInterval build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIntervalVer13(value);
        }
    }
}

