/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashGtpPortMatch;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashGtpPortMatch;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnHashGtpPortMatchSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashGtpPortMatchVer13
implements OFBsnTlvHashGtpPortMatch {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashGtpPortMatchVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 9;
    private static final int DEFAULT_SRC_PORT = 0;
    private static final int DEFAULT_DST_PORT = 0;
    private final OFBsnHashGtpPortMatch match;
    private final int srcPort;
    private final int dstPort;
    static final Reader READER = new Reader();
    static final OFBsnTlvHashGtpPortMatchVer13Funnel FUNNEL = new OFBsnTlvHashGtpPortMatchVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashGtpPortMatchVer13(OFBsnHashGtpPortMatch match, int srcPort, int dstPort) {
        if (match == null) {
            throw new NullPointerException("OFBsnTlvHashGtpPortMatchVer13: property match cannot be null");
        }
        this.match = match;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
    }

    @Override
    public int getType() {
        return 105;
    }

    @Override
    public OFBsnHashGtpPortMatch getMatch() {
        return this.match;
    }

    @Override
    public int getSrcPort() {
        return this.srcPort;
    }

    @Override
    public int getDstPort() {
        return this.dstPort;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvHashGtpPortMatch.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashGtpPortMatchVer13(");
        b.append("match=").append((Object)this.match);
        b.append(", ");
        b.append("srcPort=").append(this.srcPort);
        b.append(", ");
        b.append("dstPort=").append(this.dstPort);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashGtpPortMatchVer13 other = (OFBsnTlvHashGtpPortMatchVer13)obj;
        if (this.match == null ? other.match != null : !this.match.equals((Object)other.match)) {
            return false;
        }
        if (this.srcPort != other.srcPort) {
            return false;
        }
        return this.dstPort == other.dstPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + this.srcPort;
        result = 31 * result + this.dstPort;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashGtpPortMatchVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashGtpPortMatchVer13 message) {
            bb.writeShort(105);
            bb.writeShort(9);
            OFBsnHashGtpPortMatchSerializerVer13.writeTo(bb, message.match);
            bb.writeShort((int)U16.t(message.srcPort));
            bb.writeShort((int)U16.t(message.dstPort));
        }
    }

    static class OFBsnTlvHashGtpPortMatchVer13Funnel
    implements Funnel<OFBsnTlvHashGtpPortMatchVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashGtpPortMatchVer13Funnel() {
        }

        public void funnel(OFBsnTlvHashGtpPortMatchVer13 message, PrimitiveSink sink) {
            sink.putShort((short)105);
            sink.putShort((short)9);
            OFBsnHashGtpPortMatchSerializerVer13.putTo(message.match, sink);
            sink.putInt(message.srcPort);
            sink.putInt(message.dstPort);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashGtpPortMatch> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashGtpPortMatch readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 105) {
                throw new OFParseError("Wrong type: Expected=0x69(0x69), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 9) {
                throw new OFParseError("Wrong length: Expected=9(9), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnHashGtpPortMatch match = OFBsnHashGtpPortMatchSerializerVer13.readFrom(bb);
            int srcPort = U16.f(bb.readShort());
            int dstPort = U16.f(bb.readShort());
            OFBsnTlvHashGtpPortMatchVer13 bsnTlvHashGtpPortMatchVer13 = new OFBsnTlvHashGtpPortMatchVer13(match, srcPort, dstPort);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashGtpPortMatchVer13);
            }
            return bsnTlvHashGtpPortMatchVer13;
        }
    }

    static class Builder
    implements OFBsnTlvHashGtpPortMatch.Builder {
        private boolean matchSet;
        private OFBsnHashGtpPortMatch match;
        private boolean srcPortSet;
        private int srcPort;
        private boolean dstPortSet;
        private int dstPort;

        Builder() {
        }

        @Override
        public int getType() {
            return 105;
        }

        @Override
        public OFBsnHashGtpPortMatch getMatch() {
            return this.match;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch.Builder setMatch(OFBsnHashGtpPortMatch match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public int getSrcPort() {
            return this.srcPort;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch.Builder setSrcPort(int srcPort) {
            this.srcPort = srcPort;
            this.srcPortSet = true;
            return this;
        }

        @Override
        public int getDstPort() {
            return this.dstPort;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch.Builder setDstPort(int dstPort) {
            this.dstPort = dstPort;
            this.dstPortSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch build() {
            if (!this.matchSet) {
                throw new IllegalStateException("Property match doesn't have default value -- must be set");
            }
            if (this.match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            int srcPort = this.srcPortSet ? this.srcPort : 0;
            int dstPort = this.dstPortSet ? this.dstPort : 0;
            return new OFBsnTlvHashGtpPortMatchVer13(this.match, srcPort, dstPort);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashGtpPortMatch.Builder {
        final OFBsnTlvHashGtpPortMatchVer13 parentMessage;
        private boolean matchSet;
        private OFBsnHashGtpPortMatch match;
        private boolean srcPortSet;
        private int srcPort;
        private boolean dstPortSet;
        private int dstPort;

        BuilderWithParent(OFBsnTlvHashGtpPortMatchVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 105;
        }

        @Override
        public OFBsnHashGtpPortMatch getMatch() {
            return this.match;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch.Builder setMatch(OFBsnHashGtpPortMatch match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public int getSrcPort() {
            return this.srcPort;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch.Builder setSrcPort(int srcPort) {
            this.srcPort = srcPort;
            this.srcPortSet = true;
            return this;
        }

        @Override
        public int getDstPort() {
            return this.dstPort;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch.Builder setDstPort(int dstPort) {
            this.dstPort = dstPort;
            this.dstPortSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvHashGtpPortMatch build() {
            OFBsnHashGtpPortMatch match;
            OFBsnHashGtpPortMatch oFBsnHashGtpPortMatch = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            int srcPort = this.srcPortSet ? this.srcPort : this.parentMessage.srcPort;
            int dstPort = this.dstPortSet ? this.dstPort : this.parentMessage.dstPort;
            return new OFBsnTlvHashGtpPortMatchVer13(match, srcPort, dstPort);
        }
    }
}

