/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetSwitchPipelineRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetSwitchPipelineRequestVer13
implements OFBsnSetSwitchPipelineRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetSwitchPipelineRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 272;
    private static final long DEFAULT_XID = 0L;
    private static final String DEFAULT_PIPELINE = "";
    private final long xid;
    private final String pipeline;
    static final OFBsnSetSwitchPipelineRequestVer13 DEFAULT = new OFBsnSetSwitchPipelineRequestVer13(0L, "");
    static final Reader READER = new Reader();
    static final OFBsnSetSwitchPipelineRequestVer13Funnel FUNNEL = new OFBsnSetSwitchPipelineRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetSwitchPipelineRequestVer13(long xid, String pipeline) {
        if (pipeline == null) {
            throw new NullPointerException("OFBsnSetSwitchPipelineRequestVer13: property pipeline cannot be null");
        }
        this.xid = xid;
        this.pipeline = pipeline;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 53L;
    }

    @Override
    public String getPipeline() {
        return this.pipeline;
    }

    @Override
    public OFBsnSetSwitchPipelineRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetSwitchPipelineRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("pipeline=").append(this.pipeline);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetSwitchPipelineRequestVer13 other = (OFBsnSetSwitchPipelineRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.pipeline == null ? other.pipeline != null : !this.pipeline.equals(other.pipeline));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetSwitchPipelineRequestVer13 other = (OFBsnSetSwitchPipelineRequestVer13)obj;
        return !(this.pipeline == null ? other.pipeline != null : !this.pipeline.equals(other.pipeline));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.pipeline == null ? 0 : this.pipeline.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pipeline == null ? 0 : this.pipeline.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetSwitchPipelineRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetSwitchPipelineRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(272);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(53);
            ChannelUtils.writeFixedLengthString(bb, message.pipeline, 256);
        }
    }

    static class OFBsnSetSwitchPipelineRequestVer13Funnel
    implements Funnel<OFBsnSetSwitchPipelineRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnSetSwitchPipelineRequestVer13Funnel() {
        }

        public void funnel(OFBsnSetSwitchPipelineRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)272);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(53);
            sink.putUnencodedChars((CharSequence)message.pipeline);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetSwitchPipelineRequest> {
        Reader() {
        }

        @Override
        public OFBsnSetSwitchPipelineRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 272) {
                throw new OFParseError("Wrong length: Expected=272(272), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 53) {
                throw new OFParseError("Wrong subtype: Expected=0x35L(0x35L), got=" + subtype);
            }
            String pipeline = ChannelUtils.readFixedLengthString(bb, 256);
            OFBsnSetSwitchPipelineRequestVer13 bsnSetSwitchPipelineRequestVer13 = new OFBsnSetSwitchPipelineRequestVer13(xid, pipeline);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetSwitchPipelineRequestVer13);
            }
            return bsnSetSwitchPipelineRequestVer13;
        }
    }

    static class Builder
    implements OFBsnSetSwitchPipelineRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean pipelineSet;
        private String pipeline;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetSwitchPipelineRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 53L;
        }

        @Override
        public String getPipeline() {
            return this.pipeline;
        }

        @Override
        public OFBsnSetSwitchPipelineRequest.Builder setPipeline(String pipeline) {
            this.pipeline = pipeline;
            this.pipelineSet = true;
            return this;
        }

        @Override
        public OFBsnSetSwitchPipelineRequest build() {
            String pipeline;
            long xid = this.xidSet ? this.xid : 0L;
            String string = pipeline = this.pipelineSet ? this.pipeline : OFBsnSetSwitchPipelineRequestVer13.DEFAULT_PIPELINE;
            if (pipeline == null) {
                throw new NullPointerException("Property pipeline must not be null");
            }
            return new OFBsnSetSwitchPipelineRequestVer13(xid, pipeline);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetSwitchPipelineRequest.Builder {
        final OFBsnSetSwitchPipelineRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean pipelineSet;
        private String pipeline;

        BuilderWithParent(OFBsnSetSwitchPipelineRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetSwitchPipelineRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 53L;
        }

        @Override
        public String getPipeline() {
            return this.pipeline;
        }

        @Override
        public OFBsnSetSwitchPipelineRequest.Builder setPipeline(String pipeline) {
            this.pipeline = pipeline;
            this.pipelineSet = true;
            return this;
        }

        @Override
        public OFBsnSetSwitchPipelineRequest build() {
            String pipeline;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            String string = pipeline = this.pipelineSet ? this.pipeline : this.parentMessage.pipeline;
            if (pipeline == null) {
                throw new NullPointerException("Property pipeline must not be null");
            }
            return new OFBsnSetSwitchPipelineRequestVer13(xid, pipeline);
        }
    }
}

