/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdPushMpls;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdPushMplsVer13
implements OFActionIdPushMpls {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdPushMplsVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 4;
    static final OFActionIdPushMplsVer13 DEFAULT = new OFActionIdPushMplsVer13();
    static final OFActionIdPushMplsVer13 INSTANCE = new OFActionIdPushMplsVer13();
    static final Reader READER = new Reader();
    static final OFActionIdPushMplsVer13Funnel FUNNEL = new OFActionIdPushMplsVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdPushMplsVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.PUSH_MPLS;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdPushMpls.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdPushMplsVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdPushMplsVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdPushMplsVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdPushMplsVer13 message) {
            bb.writeShort(19);
            bb.writeShort(4);
        }
    }

    static class OFActionIdPushMplsVer13Funnel
    implements Funnel<OFActionIdPushMplsVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdPushMplsVer13Funnel() {
        }

        public void funnel(OFActionIdPushMplsVer13 message, PrimitiveSink sink) {
            sink.putShort((short)19);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdPushMpls> {
        Reader() {
        }

        @Override
        public OFActionIdPushMpls readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFActionType.PUSH_MPLS(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

