/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFConfigFlags;
import org.projectfloodlight.openflow.protocol.OFGetConfigReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFConfigFlagsSerializerVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGetConfigReplyVer12
implements OFGetConfigReply {
    private static final Logger logger = LoggerFactory.getLogger(OFGetConfigReplyVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFConfigFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final int DEFAULT_MISS_SEND_LEN = 0;
    private final long xid;
    private final Set<OFConfigFlags> flags;
    private final int missSendLen;
    static final OFGetConfigReplyVer12 DEFAULT = new OFGetConfigReplyVer12(0L, DEFAULT_FLAGS, 0);
    static final Reader READER = new Reader();
    static final OFGetConfigReplyVer12Funnel FUNNEL = new OFGetConfigReplyVer12Funnel();
    static final Writer WRITER = new Writer();

    OFGetConfigReplyVer12(long xid, Set<OFConfigFlags> flags, int missSendLen) {
        if (flags == null) {
            throw new NullPointerException("OFGetConfigReplyVer12: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.missSendLen = missSendLen;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.GET_CONFIG_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public Set<OFConfigFlags> getFlags() {
        return this.flags;
    }

    @Override
    public int getMissSendLen() {
        return this.missSendLen;
    }

    @Override
    public OFGetConfigReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGetConfigReplyVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("missSendLen=").append(this.missSendLen);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGetConfigReplyVer12 other = (OFGetConfigReplyVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.missSendLen == other.missSendLen;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGetConfigReplyVer12 other = (OFGetConfigReplyVer12)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.missSendLen == other.missSendLen;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.missSendLen;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + this.missSendLen;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGetConfigReplyVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGetConfigReplyVer12 message) {
            bb.writeByte(3);
            bb.writeByte(8);
            bb.writeShort(12);
            bb.writeInt(U32.t(message.xid));
            OFConfigFlagsSerializerVer12.writeTo(bb, message.flags);
            bb.writeShort((int)U16.t(message.missSendLen));
        }
    }

    static class OFGetConfigReplyVer12Funnel
    implements Funnel<OFGetConfigReplyVer12> {
        private static final long serialVersionUID = 1L;

        OFGetConfigReplyVer12Funnel() {
        }

        public void funnel(OFGetConfigReplyVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)8);
            sink.putShort((short)12);
            sink.putLong(message.xid);
            OFConfigFlagsSerializerVer12.putTo(message.flags, sink);
            sink.putInt(message.missSendLen);
        }
    }

    static class Reader
    implements OFMessageReader<OFGetConfigReply> {
        Reader() {
        }

        @Override
        public OFGetConfigReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 8) {
                throw new OFParseError("Wrong type: Expected=OFType.GET_CONFIG_REPLY(8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            Set<OFConfigFlags> flags = OFConfigFlagsSerializerVer12.readFrom(bb);
            int missSendLen = U16.f(bb.readShort());
            OFGetConfigReplyVer12 getConfigReplyVer12 = new OFGetConfigReplyVer12(xid, flags, missSendLen);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)getConfigReplyVer12);
            }
            return getConfigReplyVer12;
        }
    }

    static class Builder
    implements OFGetConfigReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFConfigFlags> flags;
        private boolean missSendLenSet;
        private int missSendLen;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.GET_CONFIG_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGetConfigReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Set<OFConfigFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGetConfigReply.Builder setFlags(Set<OFConfigFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getMissSendLen() {
            return this.missSendLen;
        }

        @Override
        public OFGetConfigReply.Builder setMissSendLen(int missSendLen) {
            this.missSendLen = missSendLen;
            this.missSendLenSet = true;
            return this;
        }

        @Override
        public OFGetConfigReply build() {
            Set<OFConfigFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFConfigFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int missSendLen = this.missSendLenSet ? this.missSendLen : 0;
            return new OFGetConfigReplyVer12(xid, flags, missSendLen);
        }
    }

    static class BuilderWithParent
    implements OFGetConfigReply.Builder {
        final OFGetConfigReplyVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFConfigFlags> flags;
        private boolean missSendLenSet;
        private int missSendLen;

        BuilderWithParent(OFGetConfigReplyVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.GET_CONFIG_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGetConfigReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public Set<OFConfigFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGetConfigReply.Builder setFlags(Set<OFConfigFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public int getMissSendLen() {
            return this.missSendLen;
        }

        @Override
        public OFGetConfigReply.Builder setMissSendLen(int missSendLen) {
            this.missSendLen = missSendLen;
            this.missSendLenSet = true;
            return this;
        }

        @Override
        public OFGetConfigReply build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            int missSendLen = this.missSendLenSet ? this.missSendLen : this.parentMessage.missSendLen;
            return new OFGetConfigReplyVer12(xid, flags, missSendLen);
        }
    }
}

