/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwDst;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetNwDstVer11
implements OFActionSetNwDst {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetNwDstVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_NW_ADDR = IPv4Address.NONE;
    private final IPv4Address nwAddr;
    static final OFActionSetNwDstVer11 DEFAULT = new OFActionSetNwDstVer11(DEFAULT_NW_ADDR);
    static final Reader READER = new Reader();
    static final OFActionSetNwDstVer11Funnel FUNNEL = new OFActionSetNwDstVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetNwDstVer11(IPv4Address nwAddr) {
        if (nwAddr == null) {
            throw new NullPointerException("OFActionSetNwDstVer11: property nwAddr cannot be null");
        }
        this.nwAddr = nwAddr;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_NW_DST;
    }

    @Override
    public IPv4Address getNwAddr() {
        return this.nwAddr;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetNwDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetNwDstVer11(");
        b.append("nwAddr=").append(this.nwAddr);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetNwDstVer11 other = (OFActionSetNwDstVer11)obj;
        return !(this.nwAddr == null ? other.nwAddr != null : !this.nwAddr.equals(other.nwAddr));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nwAddr == null ? 0 : this.nwAddr.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetNwDstVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetNwDstVer11 message) {
            bb.writeShort(6);
            bb.writeShort(8);
            message.nwAddr.write4Bytes(bb);
        }
    }

    static class OFActionSetNwDstVer11Funnel
    implements Funnel<OFActionSetNwDstVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetNwDstVer11Funnel() {
        }

        public void funnel(OFActionSetNwDstVer11 message, PrimitiveSink sink) {
            sink.putShort((short)6);
            sink.putShort((short)8);
            message.nwAddr.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetNwDst> {
        Reader() {
        }

        @Override
        public OFActionSetNwDst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_NW_DST(6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address nwAddr = IPv4Address.read4Bytes(bb);
            OFActionSetNwDstVer11 actionSetNwDstVer11 = new OFActionSetNwDstVer11(nwAddr);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetNwDstVer11);
            }
            return actionSetNwDstVer11;
        }
    }

    static class Builder
    implements OFActionSetNwDst.Builder {
        private boolean nwAddrSet;
        private IPv4Address nwAddr;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_DST;
        }

        @Override
        public IPv4Address getNwAddr() {
            return this.nwAddr;
        }

        @Override
        public OFActionSetNwDst.Builder setNwAddr(IPv4Address nwAddr) {
            this.nwAddr = nwAddr;
            this.nwAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetNwDst build() {
            IPv4Address nwAddr;
            IPv4Address iPv4Address = nwAddr = this.nwAddrSet ? this.nwAddr : DEFAULT_NW_ADDR;
            if (nwAddr == null) {
                throw new NullPointerException("Property nwAddr must not be null");
            }
            return new OFActionSetNwDstVer11(nwAddr);
        }
    }

    static class BuilderWithParent
    implements OFActionSetNwDst.Builder {
        final OFActionSetNwDstVer11 parentMessage;
        private boolean nwAddrSet;
        private IPv4Address nwAddr;

        BuilderWithParent(OFActionSetNwDstVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_DST;
        }

        @Override
        public IPv4Address getNwAddr() {
            return this.nwAddr;
        }

        @Override
        public OFActionSetNwDst.Builder setNwAddr(IPv4Address nwAddr) {
            this.nwAddr = nwAddr;
            this.nwAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetNwDst build() {
            IPv4Address nwAddr;
            IPv4Address iPv4Address = nwAddr = this.nwAddrSet ? this.nwAddr : this.parentMessage.nwAddr;
            if (nwAddr == null) {
                throw new NullPointerException("Property nwAddr must not be null");
            }
            return new OFActionSetNwDstVer11(nwAddr);
        }
    }
}

