/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionCopyTtlOut;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionCopyTtlOutVer11
implements OFActionCopyTtlOut {
    private static final Logger logger = LoggerFactory.getLogger(OFActionCopyTtlOutVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    static final OFActionCopyTtlOutVer11 DEFAULT = new OFActionCopyTtlOutVer11();
    static final OFActionCopyTtlOutVer11 INSTANCE = new OFActionCopyTtlOutVer11();
    static final Reader READER = new Reader();
    static final OFActionCopyTtlOutVer11Funnel FUNNEL = new OFActionCopyTtlOutVer11Funnel();
    static final Writer WRITER = new Writer();

    private OFActionCopyTtlOutVer11() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.COPY_TTL_OUT;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionCopyTtlOut.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionCopyTtlOutVer11 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionCopyTtlOutVer11(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionCopyTtlOutVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionCopyTtlOutVer11 message) {
            bb.writeShort(11);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionCopyTtlOutVer11Funnel
    implements Funnel<OFActionCopyTtlOutVer11> {
        private static final long serialVersionUID = 1L;

        OFActionCopyTtlOutVer11Funnel() {
        }

        public void funnel(OFActionCopyTtlOutVer11 message, PrimitiveSink sink) {
            sink.putShort((short)11);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionCopyTtlOut> {
        Reader() {
        }

        @Override
        public OFActionCopyTtlOut readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=OFActionType.COPY_TTL_OUT(11), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

