/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortConfig;

public class OFPortConfigSerializerVer10 {
    public static final int PORT_DOWN_VAL = 1;
    public static final int NO_STP_VAL = 2;
    public static final int NO_RECV_VAL = 4;
    public static final int NO_RECV_STP_VAL = 8;
    public static final int NO_FLOOD_VAL = 16;
    public static final int NO_FWD_VAL = 32;
    public static final int NO_PACKET_IN_VAL = 64;
    public static final int BSN_MIRROR_DEST_VAL = Integer.MIN_VALUE;

    public static Set<OFPortConfig> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortConfigSerializerVer10.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFPortConfig> set) {
        bb.writeInt(OFPortConfigSerializerVer10.toWireValue(set));
    }

    public static void putTo(Set<OFPortConfig> set, PrimitiveSink sink) {
        sink.putInt(OFPortConfigSerializerVer10.toWireValue(set));
    }

    public static Set<OFPortConfig> ofWireValue(int val) {
        EnumSet<OFPortConfig> set = EnumSet.noneOf(OFPortConfig.class);
        if ((val & 1) != 0) {
            set.add(OFPortConfig.PORT_DOWN);
        }
        if ((val & 2) != 0) {
            set.add(OFPortConfig.NO_STP);
        }
        if ((val & 4) != 0) {
            set.add(OFPortConfig.NO_RECV);
        }
        if ((val & 8) != 0) {
            set.add(OFPortConfig.NO_RECV_STP);
        }
        if ((val & 0x10) != 0) {
            set.add(OFPortConfig.NO_FLOOD);
        }
        if ((val & 0x20) != 0) {
            set.add(OFPortConfig.NO_FWD);
        }
        if ((val & 0x40) != 0) {
            set.add(OFPortConfig.NO_PACKET_IN);
        }
        if ((val & Integer.MIN_VALUE) != 0) {
            set.add(OFPortConfig.BSN_MIRROR_DEST);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFPortConfig> set) {
        int wireValue = 0;
        block10: for (OFPortConfig e : set) {
            switch (e) {
                case PORT_DOWN: {
                    wireValue |= 1;
                    continue block10;
                }
                case NO_STP: {
                    wireValue |= 2;
                    continue block10;
                }
                case NO_RECV: {
                    wireValue |= 4;
                    continue block10;
                }
                case NO_RECV_STP: {
                    wireValue |= 8;
                    continue block10;
                }
                case NO_FLOOD: {
                    wireValue |= 0x10;
                    continue block10;
                }
                case NO_FWD: {
                    wireValue |= 0x20;
                    continue block10;
                }
                case NO_PACKET_IN: {
                    wireValue |= 0x40;
                    continue block10;
                }
                case BSN_MIRROR_DEST: {
                    wireValue |= Integer.MIN_VALUE;
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFPortConfig in version 1.0: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

