/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFeaturesRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFeaturesRequestVer10
implements OFFeaturesRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFFeaturesRequestVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFFeaturesRequestVer10 DEFAULT = new OFFeaturesRequestVer10(0L);
    static final Reader READER = new Reader();
    static final OFFeaturesRequestVer10Funnel FUNNEL = new OFFeaturesRequestVer10Funnel();
    static final Writer WRITER = new Writer();

    OFFeaturesRequestVer10(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.FEATURES_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFFeaturesRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFeaturesRequestVer10(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesRequestVer10 other = (OFFeaturesRequestVer10)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFeaturesRequestVer10 other = (OFFeaturesRequestVer10)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFeaturesRequestVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFeaturesRequestVer10 message) {
            bb.writeByte(1);
            bb.writeByte(5);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFFeaturesRequestVer10Funnel
    implements Funnel<OFFeaturesRequestVer10> {
        private static final long serialVersionUID = 1L;

        OFFeaturesRequestVer10Funnel() {
        }

        public void funnel(OFFeaturesRequestVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)5);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFFeaturesRequest> {
        Reader() {
        }

        @Override
        public OFFeaturesRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=OFType.FEATURES_REQUEST(5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFFeaturesRequestVer10 featuresRequestVer10 = new OFFeaturesRequestVer10(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)featuresRequestVer10);
            }
            return featuresRequestVer10;
        }
    }

    static class Builder
    implements OFFeaturesRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFFeaturesRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFFeaturesRequestVer10(xid);
        }
    }

    static class BuilderWithParent
    implements OFFeaturesRequest.Builder {
        final OFFeaturesRequestVer10 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFFeaturesRequestVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.FEATURES_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFFeaturesRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFFeaturesRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFFeaturesRequestVer10(xid);
        }
    }
}

