/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFQueueStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueStatsReplyVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U64;

public class OFQueueStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] QUEUE_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 80, 18, 52, 86, 120, 0, 5, 0, 1, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 3, -78, -48, 94, 0, -1, -1, 0, 16, 0, 92, 22, -57, 0, 0, 0, 0, 0, 0, 0, 2};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFQueueStatsReply.Builder builder = this.factory.buildQueueStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildQueueStatsEntry().setPortNo(OFPort.of((int)1)).setQueueId(1L).setTxBytes(U64.of((long)10L)).setTxPackets(U64.of((long)7L)).setTxErrors(U64.of((long)1L)).setDurationSec(3L).setDurationNsec(3000000000L).setProperties((List)ImmutableList.of((Object)this.factory.buildQueueStatsPropBsn().setExperimenterData(new byte[]{0, 0, 0, 2}).build())).build())).build();
        OFQueueStatsReply queueStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        queueStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)QUEUE_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFQueueStatsReply.Builder builder = this.factory.buildQueueStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildQueueStatsEntry().setPortNo(OFPort.of((int)1)).setQueueId(1L).setTxBytes(U64.of((long)10L)).setTxPackets(U64.of((long)7L)).setTxErrors(U64.of((long)1L)).setDurationSec(3L).setDurationNsec(3000000000L).setProperties((List)ImmutableList.of((Object)this.factory.buildQueueStatsPropBsn().setExperimenterData(new byte[]{0, 0, 0, 2}).build())).build())).build();
        OFQueueStatsReply queueStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])QUEUE_STATS_REPLY_SERIALIZED);
        OFQueueStatsReply queueStatsReplyRead = OFQueueStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)QUEUE_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)queueStatsReplyBuilt, (Object)queueStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])QUEUE_STATS_REPLY_SERIALIZED);
        OFQueueStatsReply queueStatsReply = OFQueueStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)QUEUE_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        queueStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)QUEUE_STATS_REPLY_SERIALIZED));
    }
}

