/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescStatsReplyVer15;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPortDescStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] PORT_DESC_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 88, 18, 52, 86, 120, 0, 13, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 72, 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 80, 111, 114, 116, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 6};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortDescStatsReply.Builder builder = this.factory.buildPortDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildPortDesc().setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"00:01:02:03:04:05")).setName("Port1").setConfig((Set)ImmutableSet.of((Object)OFPortConfig.PORT_DOWN)).setState((Set)ImmutableSet.of((Object)OFPortState.LIVE)).setProperties((List)ImmutableList.of((Object)this.factory.buildPortDescPropEthernet().setCurr(1L).setAdvertised(2L).setSupported(3L).setPeer(4L).setCurrSpeed(5L).setMaxSpeed(6L).build())).build())).build();
        OFPortDescStatsReply portDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortDescStatsReply.Builder builder = this.factory.buildPortDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildPortDesc().setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"00:01:02:03:04:05")).setName("Port1").setConfig((Set)ImmutableSet.of((Object)OFPortConfig.PORT_DOWN)).setState((Set)ImmutableSet.of((Object)OFPortState.LIVE)).setProperties((List)ImmutableList.of((Object)this.factory.buildPortDescPropEthernet().setCurr(1L).setAdvertised(2L).setSupported(3L).setPeer(4L).setCurrSpeed(5L).setMaxSpeed(6L).build())).build())).build();
        OFPortDescStatsReply portDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_DESC_STATS_REPLY_SERIALIZED);
        OFPortDescStatsReply portDescStatsReplyRead = OFPortDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portDescStatsReplyBuilt, (Object)portDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_DESC_STATS_REPLY_SERIALIZED);
        OFPortDescStatsReply portDescStatsReply = OFPortDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_DESC_STATS_REPLY_SERIALIZED));
    }
}

