/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFAggregateStatsRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver15.OFAggregateStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFAggregateStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] AGGREGATE_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 64, 18, 52, 86, 120, 0, 2, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, -2, -36, -70, -104, 118, 84, 50, 16, -1, 0, -1, 0, -1, 0, -1, 0, 0, 1, 0, 16, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFAggregateStatsRequest.Builder builder = this.factory.buildAggregateStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setTableId(TableId.ALL).setOutPort(OFPort.of((int)4)).setOutGroup(OFGroup.of((int)1)).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).build();
        OFAggregateStatsRequest aggregateStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        aggregateStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)AGGREGATE_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFAggregateStatsRequest.Builder builder = this.factory.buildAggregateStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setTableId(TableId.ALL).setOutPort(OFPort.of((int)4)).setOutGroup(OFGroup.of((int)1)).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).build();
        OFAggregateStatsRequest aggregateStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])AGGREGATE_STATS_REQUEST_SERIALIZED);
        OFAggregateStatsRequest aggregateStatsRequestRead = OFAggregateStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)AGGREGATE_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)aggregateStatsRequestBuilt, (Object)aggregateStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])AGGREGATE_STATS_REQUEST_SERIALIZED);
        OFAggregateStatsRequest aggregateStatsRequest = OFAggregateStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)AGGREGATE_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        aggregateStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)AGGREGATE_STATS_REQUEST_SERIALIZED));
    }
}

