/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFConfigFlags;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGetConfigReply;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGetConfigReplyVer13;

public class OFGetConfigReplyVer13Test {
    OFFactory factory;
    static final byte[] GET_CONFIG_REPLY_SERIALIZED = new byte[]{4, 8, 0, 12, 18, 52, 86, 120, 0, 2, -1, -1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGetConfigReply.Builder builder = this.factory.buildGetConfigReply();
        builder.setXid(305419896L).setFlags((Set)Sets.immutableEnumSet((Enum)OFConfigFlags.FRAG_REASM, (Enum[])new OFConfigFlags[0])).setMissSendLen(65535).build();
        OFGetConfigReply getConfigReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        getConfigReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GET_CONFIG_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGetConfigReply.Builder builder = this.factory.buildGetConfigReply();
        builder.setXid(305419896L).setFlags((Set)Sets.immutableEnumSet((Enum)OFConfigFlags.FRAG_REASM, (Enum[])new OFConfigFlags[0])).setMissSendLen(65535).build();
        OFGetConfigReply getConfigReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GET_CONFIG_REPLY_SERIALIZED);
        OFGetConfigReply getConfigReplyRead = OFGetConfigReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)GET_CONFIG_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)getConfigReplyBuilt, (Object)getConfigReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GET_CONFIG_REPLY_SERIALIZED);
        OFGetConfigReply getConfigReply = OFGetConfigReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)GET_CONFIG_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        getConfigReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GET_CONFIG_REPLY_SERIALIZED));
    }
}

