/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedLongs;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import org.projectfloodlight.openflow.types.HashValue;
import org.projectfloodlight.openflow.types.HashValueUtils;
import org.projectfloodlight.openflow.types.OFValueType;

public class U128
implements OFValueType<U128>,
HashValue<U128> {
    static final int LENGTH = 16;
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    private static final long NO_MASK_VAL = -1L;
    private final long raw1;
    private final long raw2;
    public static final U128 ZERO = new U128(0L, 0L);
    public static final U128 NO_MASK = new U128(-1L, -1L);
    public static final U128 FULL_MASK = ZERO;

    private U128(long raw1, long raw2) {
        this.raw1 = raw1;
        this.raw2 = raw2;
    }

    public static U128 of(long raw1, long raw2) {
        if (raw1 == 0L && raw2 == 0L) {
            return ZERO;
        }
        if (raw1 == -1L && raw2 == -1L) {
            return NO_MASK;
        }
        return new U128(raw1, raw2);
    }

    @Override
    public int getLength() {
        return 16;
    }

    public long getMsb() {
        return this.raw1;
    }

    public long getLsb() {
        return this.raw2;
    }

    @Override
    public U128 applyMask(U128 mask) {
        return this.and(mask);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.raw1 ^ this.raw1 >>> 32);
        result = 31 * result + (int)(this.raw2 ^ this.raw2 >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        U128 other = (U128)obj;
        if (this.raw1 != other.raw1) {
            return false;
        }
        return this.raw2 == other.raw2;
    }

    public void write16Bytes(ByteBuf cb) {
        cb.writeLong(this.raw1);
        cb.writeLong(this.raw2);
    }

    public static U128 read16Bytes(ByteBuf cb) {
        long raw1 = cb.readLong();
        long raw2 = cb.readLong();
        return U128.of(raw1, raw2);
    }

    public String toString() {
        return String.format("0x%016x%016x", this.raw1, this.raw2);
    }

    @Override
    public int compareTo(@Nonnull U128 o) {
        int msb = UnsignedLongs.compare((long)this.raw1, (long)o.raw1);
        if (msb != 0) {
            return msb;
        }
        return UnsignedLongs.compare((long)this.raw2, (long)o.raw2);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putLong(this.raw1);
        sink.putLong(this.raw2);
    }

    @Override
    public U128 inverse() {
        return U128.of(this.raw1 ^ 0xFFFFFFFFFFFFFFFFL, this.raw2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public U128 or(U128 other) {
        return U128.of(this.raw1 | other.raw1, this.raw2 | other.raw2);
    }

    @Override
    public U128 and(U128 other) {
        return U128.of(this.raw1 & other.raw1, this.raw2 & other.raw2);
    }

    @Override
    public U128 xor(U128 other) {
        return U128.of(this.raw1 ^ other.raw1, this.raw2 ^ other.raw2);
    }

    @Override
    public U128 add(U128 other) {
        long newRaw2 = this.raw2 + other.raw2;
        long newRaw1 = this.raw1 + other.raw1;
        if (UnsignedLongs.compare((long)newRaw2, (long)this.raw2) < 0) {
            ++newRaw1;
        }
        return U128.of(newRaw1, newRaw2);
    }

    @Override
    public U128 subtract(U128 other) {
        long newRaw2 = this.raw2 - other.raw2;
        long newRaw1 = this.raw1 - other.raw1;
        if (UnsignedLongs.compare((long)this.raw2, (long)other.raw2) < 0) {
            --newRaw1;
        }
        return U128.of(newRaw1, newRaw2);
    }

    @Override
    public int prefixBits(int numBits) {
        return HashValueUtils.prefixBits(this.raw1, numBits);
    }

    @Override
    public HashValue.Builder<U128> builder() {
        return new U128Builder(this.raw1, this.raw2);
    }

    static class U128Builder
    implements HashValue.Builder<U128> {
        private long raw1;
        private long raw2;

        public U128Builder(long raw1, long raw2) {
            this.raw1 = raw1;
            this.raw2 = raw2;
        }

        @Override
        public HashValue.Builder<U128> add(U128 other) {
            this.raw2 += other.raw2;
            this.raw1 += other.raw1;
            if (UnsignedLongs.compare((long)this.raw2, (long)other.raw2) < 0) {
                ++this.raw1;
            }
            return this;
        }

        @Override
        public HashValue.Builder<U128> subtract(U128 other) {
            if (UnsignedLongs.compare((long)this.raw2, (long)other.raw2) >= 0) {
                this.raw2 -= other.raw2;
                this.raw1 -= other.raw1;
            } else {
                this.raw2 -= other.raw2;
                this.raw1 = this.raw1 - other.raw1 - 1L;
            }
            return this;
        }

        @Override
        public HashValue.Builder<U128> invert() {
            this.raw1 ^= 0xFFFFFFFFFFFFFFFFL;
            this.raw2 ^= 0xFFFFFFFFFFFFFFFFL;
            return this;
        }

        @Override
        public HashValue.Builder<U128> or(U128 other) {
            this.raw1 |= other.raw1;
            this.raw2 |= other.raw2;
            return this;
        }

        @Override
        public HashValue.Builder<U128> and(U128 other) {
            this.raw1 &= other.raw1;
            this.raw2 &= other.raw2;
            return this;
        }

        @Override
        public HashValue.Builder<U128> xor(U128 other) {
            this.raw1 ^= other.raw1;
            this.raw2 ^= other.raw2;
            return this;
        }

        @Override
        public U128 build() {
            return U128.of(this.raw1, this.raw2);
        }
    }
}

