/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;

public class OFAuxId
implements Comparable<OFAuxId>,
PrimitiveSinkable {
    private static final short VALIDATION_MASK = 255;
    private static final short MAIN_VAL = 0;
    public static final OFAuxId MAIN = new OFAuxId(0);
    private final short id;

    private OFAuxId(short id) {
        this.id = id;
    }

    public static OFAuxId of(short id) {
        switch (id) {
            case 0: {
                return MAIN;
            }
        }
        if ((id & 0xFF) != id) {
            throw new IllegalArgumentException("Illegal Aux id value: " + id);
        }
        return new OFAuxId(id);
    }

    public static OFAuxId of(int id) {
        if ((id & 0xFF) != id) {
            throw new IllegalArgumentException("Illegal Aux id value: " + id);
        }
        return OFAuxId.of((short)id);
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAuxId other = (OFAuxId)obj;
        return this.id == other.id;
    }

    public short getValue() {
        return this.id;
    }

    public void writeByte(ByteBuf c) {
        c.writeByte((int)this.id);
    }

    public static OFAuxId readByte(ByteBuf c) throws OFParseError {
        return OFAuxId.of(c.readUnsignedByte());
    }

    @Override
    public int compareTo(OFAuxId other) {
        return Shorts.compare((short)this.id, (short)other.id);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte((byte)this.id);
    }
}

