/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.types.OFValueType;

public class IpProtocol
implements OFValueType<IpProtocol> {
    static final short MAX_PROTO = 255;
    static final int LENGTH = 1;
    private final short proto;
    static final short NUM_HOPOPT = 0;
    static final short NUM_ICMP = 1;
    static final short NUM_IGMP = 2;
    static final short NUM_GGP = 3;
    static final short NUM_IPv4 = 4;
    static final short NUM_ST = 5;
    static final short NUM_TCP = 6;
    static final short NUM_CBT = 7;
    static final short NUM_EGP = 8;
    static final short NUM_IGP = 9;
    static final short NUM_BBN_RCC_MON = 10;
    static final short NUM_NVP_II = 11;
    static final short NUM_PUP = 12;
    static final short NUM_ARGUS = 13;
    static final short NUM_EMCON = 14;
    static final short NUM_XNET = 15;
    static final short NUM_CHAOS = 16;
    static final short NUM_UDP = 17;
    static final short NUM_MUX = 18;
    static final short NUM_DCN_MEAS = 19;
    static final short NUM_HMP = 20;
    static final short NUM_PRM = 21;
    static final short NUM_XNS_IDP = 22;
    static final short NUM_TRUNK_1 = 23;
    static final short NUM_TRUNK_2 = 24;
    static final short NUM_LEAF_1 = 25;
    static final short NUM_LEAF_2 = 26;
    static final short NUM_RDP = 27;
    static final short NUM_IRTP = 28;
    static final short NUM_ISO_TP4 = 29;
    static final short NUM_NETBLT = 30;
    static final short NUM_MFE_NSP = 31;
    static final short NUM_MERIT_INP = 32;
    static final short NUM_DCCP = 33;
    static final short NUM_3PC = 34;
    static final short NUM_IDPR = 35;
    static final short NUM_XTP = 36;
    static final short NUM_DDP = 37;
    static final short NUM_IDPR_CMTP = 38;
    static final short NUM_TP_PP = 39;
    static final short NUM_IL = 40;
    static final short NUM_IPv6 = 41;
    static final short NUM_SDRP = 42;
    static final short NUM_IPv6_ROUTE = 43;
    static final short NUM_IPv6_FRAG = 44;
    static final short NUM_IDRP = 45;
    static final short NUM_RSVP = 46;
    static final short NUM_GRE = 47;
    static final short NUM_MHRP = 48;
    static final short NUM_BNA = 49;
    static final short NUM_ESP = 50;
    static final short NUM_AH = 51;
    static final short NUM_I_NLSP = 52;
    static final short NUM_SWIPE = 53;
    static final short NUM_NARP = 54;
    static final short NUM_MOBILE = 55;
    static final short NUM_TLSP = 56;
    static final short NUM_SKIP = 57;
    static final short NUM_IPv6_ICMP = 58;
    static final short NUM_IPv6_NO_NXT = 59;
    static final short NUM_IPv6_OPTS = 60;
    static final short NUM_HOST_INTERNAL = 61;
    static final short NUM_CFTP = 62;
    static final short NUM_LOCAL_NET = 63;
    static final short NUM_SAT_EXPAK = 64;
    static final short NUM_KRYPTOLAN = 65;
    static final short NUM_RVD = 66;
    static final short NUM_IPPC = 67;
    static final short NUM_DIST_FS = 68;
    static final short NUM_SAT_MON = 69;
    static final short NUM_VISA = 70;
    static final short NUM_IPCV = 71;
    static final short NUM_CPNX = 72;
    static final short NUM_CPHB = 73;
    static final short NUM_WSN = 74;
    static final short NUM_PVP = 75;
    static final short NUM_BR_SAT_MON = 76;
    static final short NUM_SUN_ND = 77;
    static final short NUM_WB_MON = 78;
    static final short NUM_WB_EXPAK = 79;
    static final short NUM_ISO_IP = 80;
    static final short NUM_VMTP = 81;
    static final short NUM_SECURE_VMTP = 82;
    static final short NUM_VINES = 83;
    static final short NUM_TTP_IPTM = 84;
    static final short NUM_NSFNET_IGP = 85;
    static final short NUM_DGP = 86;
    static final short NUM_TCF = 87;
    static final short NUM_EIGRP = 88;
    static final short NUM_OSPF = 89;
    static final short NUM_Sprite_RPC = 90;
    static final short NUM_LARP = 91;
    static final short NUM_MTP = 92;
    static final short NUM_AX_25 = 93;
    static final short NUM_IPIP = 94;
    static final short NUM_MICP = 95;
    static final short NUM_SCC_SP = 96;
    static final short NUM_ETHERIP = 97;
    static final short NUM_ENCAP = 98;
    static final short NUM_PRIVATE_ENCRYPT = 99;
    static final short NUM_GMTP = 100;
    static final short NUM_IFMP = 101;
    static final short NUM_PNNI = 102;
    static final short NUM_PIM = 103;
    static final short NUM_ARIS = 104;
    static final short NUM_SCPS = 105;
    static final short NUM_QNX = 106;
    static final short NUM_A_N = 107;
    static final short NUM_IP_COMP = 108;
    static final short NUM_SNP = 109;
    static final short NUM_COMPAQ_PEER = 110;
    static final short NUM_IPX_IN_IP = 111;
    static final short NUM_VRRP = 112;
    static final short NUM_PGM = 113;
    static final short NUM_ZERO_HOP = 114;
    static final short NUM_L2TP = 115;
    static final short NUM_DDX = 116;
    static final short NUM_IATP = 117;
    static final short NUM_STP = 118;
    static final short NUM_SRP = 119;
    static final short NUM_UTI = 120;
    static final short NUM_SMP = 121;
    static final short NUM_SM = 122;
    static final short NUM_PTP = 123;
    static final short NUM_IS_IS_OVER_IPv4 = 124;
    static final short NUM_FIRE = 125;
    static final short NUM_CRTP = 126;
    static final short NUM_CRUDP = 127;
    static final short NUM_SSCOPMCE = 128;
    static final short NUM_IPLT = 129;
    static final short NUM_SPS = 130;
    static final short NUM_PIPE = 131;
    static final short NUM_SCTP = 132;
    static final short NUM_FC = 133;
    static final short NUM_RSVP_E2E_IGNORE = 134;
    static final short NUM_MOBILITY_HEADER = 135;
    static final short NUM_UDP_LITE = 136;
    static final short NUM_MPLS_IN_IP = 137;
    static final short NUM_MANET = 138;
    static final short NUM_HIP = 139;
    static final short NUM_SHIM6 = 140;
    public static final IpProtocol HOPOPT = new IpProtocol(0);
    public static final IpProtocol ICMP = new IpProtocol(1);
    public static final IpProtocol IGMP = new IpProtocol(2);
    public static final IpProtocol GGP = new IpProtocol(3);
    public static final IpProtocol IPv4 = new IpProtocol(4);
    public static final IpProtocol ST = new IpProtocol(5);
    public static final IpProtocol TCP = new IpProtocol(6);
    public static final IpProtocol CBT = new IpProtocol(7);
    public static final IpProtocol EGP = new IpProtocol(8);
    public static final IpProtocol IGP = new IpProtocol(9);
    public static final IpProtocol BBN_RCC_MON = new IpProtocol(10);
    public static final IpProtocol NVP_II = new IpProtocol(11);
    public static final IpProtocol PUP = new IpProtocol(12);
    public static final IpProtocol ARGUS = new IpProtocol(13);
    public static final IpProtocol EMCON = new IpProtocol(14);
    public static final IpProtocol XNET = new IpProtocol(15);
    public static final IpProtocol CHAOS = new IpProtocol(16);
    public static final IpProtocol UDP = new IpProtocol(17);
    public static final IpProtocol MUX = new IpProtocol(18);
    public static final IpProtocol DCN_MEAS = new IpProtocol(19);
    public static final IpProtocol HMP = new IpProtocol(20);
    public static final IpProtocol PRM = new IpProtocol(21);
    public static final IpProtocol XNS_IDP = new IpProtocol(22);
    public static final IpProtocol TRUNK_1 = new IpProtocol(23);
    public static final IpProtocol TRUNK_2 = new IpProtocol(24);
    public static final IpProtocol LEAF_1 = new IpProtocol(25);
    public static final IpProtocol LEAF_2 = new IpProtocol(26);
    public static final IpProtocol RDP = new IpProtocol(27);
    public static final IpProtocol IRTP = new IpProtocol(28);
    public static final IpProtocol ISO_TP4 = new IpProtocol(29);
    public static final IpProtocol NETBLT = new IpProtocol(30);
    public static final IpProtocol MFE_NSP = new IpProtocol(31);
    public static final IpProtocol MERIT_INP = new IpProtocol(32);
    public static final IpProtocol DCCP = new IpProtocol(33);
    public static final IpProtocol _3PC = new IpProtocol(34);
    public static final IpProtocol IDPR = new IpProtocol(35);
    public static final IpProtocol XTP = new IpProtocol(36);
    public static final IpProtocol DDP = new IpProtocol(37);
    public static final IpProtocol IDPR_CMTP = new IpProtocol(38);
    public static final IpProtocol TP_PP = new IpProtocol(39);
    public static final IpProtocol IL = new IpProtocol(40);
    public static final IpProtocol IPv6 = new IpProtocol(41);
    public static final IpProtocol SDRP = new IpProtocol(42);
    public static final IpProtocol IPv6_ROUTE = new IpProtocol(43);
    public static final IpProtocol IPv6_FRAG = new IpProtocol(44);
    public static final IpProtocol IDRP = new IpProtocol(45);
    public static final IpProtocol RSVP = new IpProtocol(46);
    public static final IpProtocol GRE = new IpProtocol(47);
    public static final IpProtocol MHRP = new IpProtocol(48);
    public static final IpProtocol BNA = new IpProtocol(49);
    public static final IpProtocol ESP = new IpProtocol(50);
    public static final IpProtocol AH = new IpProtocol(51);
    public static final IpProtocol I_NLSP = new IpProtocol(52);
    public static final IpProtocol SWIPE = new IpProtocol(53);
    public static final IpProtocol NARP = new IpProtocol(54);
    public static final IpProtocol MOBILE = new IpProtocol(55);
    public static final IpProtocol TLSP = new IpProtocol(56);
    public static final IpProtocol SKIP = new IpProtocol(57);
    public static final IpProtocol IPv6_ICMP = new IpProtocol(58);
    public static final IpProtocol IPv6_NO_NXT = new IpProtocol(59);
    public static final IpProtocol IPv6_OPTS = new IpProtocol(60);
    public static final IpProtocol HOST_INTERNAL = new IpProtocol(61);
    public static final IpProtocol CFTP = new IpProtocol(62);
    public static final IpProtocol LOCAL_NET = new IpProtocol(63);
    public static final IpProtocol SAT_EXPAK = new IpProtocol(64);
    public static final IpProtocol KRYPTOLAN = new IpProtocol(65);
    public static final IpProtocol RVD = new IpProtocol(66);
    public static final IpProtocol IPPC = new IpProtocol(67);
    public static final IpProtocol DIST_FS = new IpProtocol(68);
    public static final IpProtocol SAT_MON = new IpProtocol(69);
    public static final IpProtocol VISA = new IpProtocol(70);
    public static final IpProtocol IPCV = new IpProtocol(71);
    public static final IpProtocol CPNX = new IpProtocol(72);
    public static final IpProtocol CPHB = new IpProtocol(73);
    public static final IpProtocol WSN = new IpProtocol(74);
    public static final IpProtocol PVP = new IpProtocol(75);
    public static final IpProtocol BR_SAT_MON = new IpProtocol(76);
    public static final IpProtocol SUN_ND = new IpProtocol(77);
    public static final IpProtocol WB_MON = new IpProtocol(78);
    public static final IpProtocol WB_EXPAK = new IpProtocol(79);
    public static final IpProtocol ISO_IP = new IpProtocol(80);
    public static final IpProtocol VMTP = new IpProtocol(81);
    public static final IpProtocol SECURE_VMTP = new IpProtocol(82);
    public static final IpProtocol VINES = new IpProtocol(83);
    public static final IpProtocol TTP_IPTM = new IpProtocol(84);
    public static final IpProtocol NSFNET_IGP = new IpProtocol(85);
    public static final IpProtocol DGP = new IpProtocol(86);
    public static final IpProtocol TCF = new IpProtocol(87);
    public static final IpProtocol EIGRP = new IpProtocol(88);
    public static final IpProtocol OSPF = new IpProtocol(89);
    public static final IpProtocol Sprite_RPC = new IpProtocol(90);
    public static final IpProtocol LARP = new IpProtocol(91);
    public static final IpProtocol MTP = new IpProtocol(92);
    public static final IpProtocol AX_25 = new IpProtocol(93);
    public static final IpProtocol IPIP = new IpProtocol(94);
    public static final IpProtocol MICP = new IpProtocol(95);
    public static final IpProtocol SCC_SP = new IpProtocol(96);
    public static final IpProtocol ETHERIP = new IpProtocol(97);
    public static final IpProtocol ENCAP = new IpProtocol(98);
    public static final IpProtocol PRIVATE_ENCRYPT = new IpProtocol(99);
    public static final IpProtocol GMTP = new IpProtocol(100);
    public static final IpProtocol IFMP = new IpProtocol(101);
    public static final IpProtocol PNNI = new IpProtocol(102);
    public static final IpProtocol PIM = new IpProtocol(103);
    public static final IpProtocol ARIS = new IpProtocol(104);
    public static final IpProtocol SCPS = new IpProtocol(105);
    public static final IpProtocol QNX = new IpProtocol(106);
    public static final IpProtocol A_N = new IpProtocol(107);
    public static final IpProtocol IP_COMP = new IpProtocol(108);
    public static final IpProtocol SNP = new IpProtocol(109);
    public static final IpProtocol COMPAQ_PEER = new IpProtocol(110);
    public static final IpProtocol IPX_IN_IP = new IpProtocol(111);
    public static final IpProtocol VRRP = new IpProtocol(112);
    public static final IpProtocol PGM = new IpProtocol(113);
    public static final IpProtocol ZERO_HOP = new IpProtocol(114);
    public static final IpProtocol L2TP = new IpProtocol(115);
    public static final IpProtocol DDX = new IpProtocol(116);
    public static final IpProtocol IATP = new IpProtocol(117);
    public static final IpProtocol STP = new IpProtocol(118);
    public static final IpProtocol SRP = new IpProtocol(119);
    public static final IpProtocol UTI = new IpProtocol(120);
    public static final IpProtocol SMP = new IpProtocol(121);
    public static final IpProtocol SM = new IpProtocol(122);
    public static final IpProtocol PTP = new IpProtocol(123);
    public static final IpProtocol IS_IS_OVER_IPv4 = new IpProtocol(124);
    public static final IpProtocol FIRE = new IpProtocol(125);
    public static final IpProtocol CRTP = new IpProtocol(126);
    public static final IpProtocol CRUDP = new IpProtocol(127);
    public static final IpProtocol SSCOPMCE = new IpProtocol(128);
    public static final IpProtocol IPLT = new IpProtocol(129);
    public static final IpProtocol SPS = new IpProtocol(130);
    public static final IpProtocol PIPE = new IpProtocol(131);
    public static final IpProtocol SCTP = new IpProtocol(132);
    public static final IpProtocol FC = new IpProtocol(133);
    public static final IpProtocol RSVP_E2E_IGNORE = new IpProtocol(134);
    public static final IpProtocol MOBILITY_HEADER = new IpProtocol(135);
    public static final IpProtocol UDP_LITE = new IpProtocol(136);
    public static final IpProtocol MPLS_IN_IP = new IpProtocol(137);
    public static final IpProtocol MANET = new IpProtocol(138);
    public static final IpProtocol HIP = new IpProtocol(139);
    public static final IpProtocol SHIM6 = new IpProtocol(140);
    public static final IpProtocol NONE = HOPOPT;
    public static final IpProtocol NO_MASK = HOPOPT;
    public static final IpProtocol FULL_MASK = new IpProtocol(0);

    private IpProtocol(short version) {
        this.proto = version;
    }

    @Override
    public int getLength() {
        return 1;
    }

    public static IpProtocol of(short proto) {
        switch (proto) {
            case 0: {
                return HOPOPT;
            }
            case 1: {
                return ICMP;
            }
            case 2: {
                return IGMP;
            }
            case 3: {
                return GGP;
            }
            case 4: {
                return IPv4;
            }
            case 5: {
                return ST;
            }
            case 6: {
                return TCP;
            }
            case 7: {
                return CBT;
            }
            case 8: {
                return EGP;
            }
            case 9: {
                return IGP;
            }
            case 10: {
                return BBN_RCC_MON;
            }
            case 11: {
                return NVP_II;
            }
            case 12: {
                return PUP;
            }
            case 13: {
                return ARGUS;
            }
            case 14: {
                return EMCON;
            }
            case 15: {
                return XNET;
            }
            case 16: {
                return CHAOS;
            }
            case 17: {
                return UDP;
            }
            case 18: {
                return MUX;
            }
            case 19: {
                return DCN_MEAS;
            }
            case 20: {
                return HMP;
            }
            case 21: {
                return PRM;
            }
            case 22: {
                return XNS_IDP;
            }
            case 23: {
                return TRUNK_1;
            }
            case 24: {
                return TRUNK_2;
            }
            case 25: {
                return LEAF_1;
            }
            case 26: {
                return LEAF_2;
            }
            case 27: {
                return RDP;
            }
            case 28: {
                return IRTP;
            }
            case 29: {
                return ISO_TP4;
            }
            case 30: {
                return NETBLT;
            }
            case 31: {
                return MFE_NSP;
            }
            case 32: {
                return MERIT_INP;
            }
            case 33: {
                return DCCP;
            }
            case 34: {
                return _3PC;
            }
            case 35: {
                return IDPR;
            }
            case 36: {
                return XTP;
            }
            case 37: {
                return DDP;
            }
            case 38: {
                return IDPR_CMTP;
            }
            case 39: {
                return TP_PP;
            }
            case 40: {
                return IL;
            }
            case 41: {
                return IPv6;
            }
            case 42: {
                return SDRP;
            }
            case 43: {
                return IPv6_ROUTE;
            }
            case 44: {
                return IPv6_FRAG;
            }
            case 45: {
                return IDRP;
            }
            case 46: {
                return RSVP;
            }
            case 47: {
                return GRE;
            }
            case 48: {
                return MHRP;
            }
            case 49: {
                return BNA;
            }
            case 50: {
                return ESP;
            }
            case 51: {
                return AH;
            }
            case 52: {
                return I_NLSP;
            }
            case 53: {
                return SWIPE;
            }
            case 54: {
                return NARP;
            }
            case 55: {
                return MOBILE;
            }
            case 56: {
                return TLSP;
            }
            case 57: {
                return SKIP;
            }
            case 58: {
                return IPv6_ICMP;
            }
            case 59: {
                return IPv6_NO_NXT;
            }
            case 60: {
                return IPv6_OPTS;
            }
            case 61: {
                return HOST_INTERNAL;
            }
            case 62: {
                return CFTP;
            }
            case 63: {
                return LOCAL_NET;
            }
            case 64: {
                return SAT_EXPAK;
            }
            case 65: {
                return KRYPTOLAN;
            }
            case 66: {
                return RVD;
            }
            case 67: {
                return IPPC;
            }
            case 68: {
                return DIST_FS;
            }
            case 69: {
                return SAT_MON;
            }
            case 70: {
                return VISA;
            }
            case 71: {
                return IPCV;
            }
            case 72: {
                return CPNX;
            }
            case 73: {
                return CPHB;
            }
            case 74: {
                return WSN;
            }
            case 75: {
                return PVP;
            }
            case 76: {
                return BR_SAT_MON;
            }
            case 77: {
                return SUN_ND;
            }
            case 78: {
                return WB_MON;
            }
            case 79: {
                return WB_EXPAK;
            }
            case 80: {
                return ISO_IP;
            }
            case 81: {
                return VMTP;
            }
            case 82: {
                return SECURE_VMTP;
            }
            case 83: {
                return VINES;
            }
            case 84: {
                return TTP_IPTM;
            }
            case 85: {
                return NSFNET_IGP;
            }
            case 86: {
                return DGP;
            }
            case 87: {
                return TCF;
            }
            case 88: {
                return EIGRP;
            }
            case 89: {
                return OSPF;
            }
            case 90: {
                return Sprite_RPC;
            }
            case 91: {
                return LARP;
            }
            case 92: {
                return MTP;
            }
            case 93: {
                return AX_25;
            }
            case 94: {
                return IPIP;
            }
            case 95: {
                return MICP;
            }
            case 96: {
                return SCC_SP;
            }
            case 97: {
                return ETHERIP;
            }
            case 98: {
                return ENCAP;
            }
            case 99: {
                return PRIVATE_ENCRYPT;
            }
            case 100: {
                return GMTP;
            }
            case 101: {
                return IFMP;
            }
            case 102: {
                return PNNI;
            }
            case 103: {
                return PIM;
            }
            case 104: {
                return ARIS;
            }
            case 105: {
                return SCPS;
            }
            case 106: {
                return QNX;
            }
            case 107: {
                return A_N;
            }
            case 108: {
                return IP_COMP;
            }
            case 109: {
                return SNP;
            }
            case 110: {
                return COMPAQ_PEER;
            }
            case 111: {
                return IPX_IN_IP;
            }
            case 112: {
                return VRRP;
            }
            case 113: {
                return PGM;
            }
            case 114: {
                return ZERO_HOP;
            }
            case 115: {
                return L2TP;
            }
            case 116: {
                return DDX;
            }
            case 117: {
                return IATP;
            }
            case 118: {
                return STP;
            }
            case 119: {
                return SRP;
            }
            case 120: {
                return UTI;
            }
            case 121: {
                return SMP;
            }
            case 122: {
                return SM;
            }
            case 123: {
                return PTP;
            }
            case 124: {
                return IS_IS_OVER_IPv4;
            }
            case 125: {
                return FIRE;
            }
            case 126: {
                return CRTP;
            }
            case 127: {
                return CRUDP;
            }
            case 128: {
                return SSCOPMCE;
            }
            case 129: {
                return IPLT;
            }
            case 130: {
                return SPS;
            }
            case 131: {
                return PIPE;
            }
            case 132: {
                return SCTP;
            }
            case 133: {
                return FC;
            }
            case 134: {
                return RSVP_E2E_IGNORE;
            }
            case 135: {
                return MOBILITY_HEADER;
            }
            case 136: {
                return UDP_LITE;
            }
            case 137: {
                return MPLS_IN_IP;
            }
            case 138: {
                return MANET;
            }
            case 139: {
                return HIP;
            }
            case 140: {
                return SHIM6;
            }
        }
        if (proto >= 255) {
            throw new IllegalArgumentException("Illegal IP protocol number: " + proto);
        }
        return new IpProtocol(proto);
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.proto);
    }

    public void writeByte(ByteBuf c) {
        c.writeByte((int)this.proto);
    }

    public static IpProtocol readByte(ByteBuf c) {
        return IpProtocol.of(c.readUnsignedByte());
    }

    @Override
    public IpProtocol applyMask(IpProtocol mask) {
        return IpProtocol.of((short)(this.proto & mask.proto));
    }

    public short getIpProtocolNumber() {
        return this.proto;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IpProtocol)) {
            return false;
        }
        IpProtocol o = (IpProtocol)obj;
        return o.proto == this.proto;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + this.proto;
        return result;
    }

    @Override
    public int compareTo(IpProtocol o) {
        return Shorts.compare((short)this.proto, (short)o.proto);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.proto);
    }
}

