/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public enum IpEcn implements OFValueType<IpEcn>
{
    ECN_00(0),
    ECN_01(1),
    ECN_10(2),
    ECN_11(3),
    ECN_NO_MASK(-1);

    public static final IpEcn NONE;
    public static final IpEcn NO_MASK;
    public static final IpEcn FULL_MASK;
    static final int LENGTH = 1;
    private final byte ecn;

    private IpEcn(byte ecn) {
        this.ecn = ecn;
    }

    public static IpEcn of(byte ecn) {
        switch (ecn) {
            case 0: {
                return ECN_00;
            }
            case 1: {
                return ECN_01;
            }
            case 2: {
                return ECN_10;
            }
            case 3: {
                return ECN_11;
            }
        }
        throw new IllegalArgumentException("Illegal IP ECN value: " + ecn);
    }

    @Override
    public int getLength() {
        return 1;
    }

    public String toString() {
        return (this.ecn < 3 ? "0" : "") + Integer.toBinaryString(this.ecn);
    }

    public void writeByte(ByteBuf c) {
        c.writeByte((int)this.ecn);
    }

    public static IpEcn readByte(ByteBuf c) throws OFParseError {
        return IpEcn.of((byte)c.readUnsignedByte());
    }

    @Override
    public IpEcn applyMask(IpEcn mask) {
        return IpEcn.of((byte)(this.ecn & mask.ecn));
    }

    public byte getEcnValue() {
        return this.ecn;
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte(this.ecn);
    }

    static {
        NONE = ECN_00;
        NO_MASK = ECN_NO_MASK;
        FULL_MASK = ECN_00;
    }
}

