/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.ver15.OFAggregateStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeaturesStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFDescStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFExperimenterStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowLightweightStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupDescStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupFeaturesStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterConfigStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterFeaturesStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortDescStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueDescStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableDescStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableFeaturesStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableStatsReplyVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsReplyVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsReplyVer15() {
    }

    static class Reader
    implements OFMessageReader<OFStatsReply> {
        Reader() {
        }

        @Override
        public OFStatsReply readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsReplyVer15.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsReplyVer15.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsReplyVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsReplyVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsReplyVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsReplyVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsReplyVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsReplyVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsReplyVer15.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsReplyVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFMeterConfigStatsReplyVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFMeterFeaturesStatsReplyVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFMeterStatsReplyVer15.READER.readFrom(bb);
                }
                case 13: {
                    return OFPortDescStatsReplyVer15.READER.readFrom(bb);
                }
                case 12: {
                    return OFTableFeaturesStatsReplyVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFQueueDescStatsReplyVer15.READER.readFrom(bb);
                }
                case 14: {
                    return OFTableDescStatsReplyVer15.READER.readFrom(bb);
                }
                case 19: {
                    return OFBundleFeaturesStatsReplyVer15.READER.readFrom(bb);
                }
                case 18: {
                    return OFControllerStatusStatsReplyVer15.READER.readFrom(bb);
                }
                case 17: {
                    return OFFlowLightweightStatsReplyVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFFlowMonitorReplyVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsReplyVer15: " + statsType);
        }
    }
}

