/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.AbstractIterator;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.OFStatV6;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.stat.StatField;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsVer15;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFStatV6Ver15
implements OFStatV6 {
    private static final Logger logger = LoggerFactory.getLogger(OFStatV6Ver15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    private static final OFOxsList DEFAULT_OXS_FIELDS = OFOxsList.EMPTY;
    private final OFOxsList oxsFields;
    static final OFStatV6Ver15 DEFAULT = new OFStatV6Ver15(DEFAULT_OXS_FIELDS);
    static final Reader READER = new Reader();
    static final OFStatV6Ver15Funnel FUNNEL = new OFStatV6Ver15Funnel();
    static final Writer WRITER = new Writer();

    OFStatV6Ver15(OFOxsList oxsFields) {
        if (oxsFields == null) {
            throw new NullPointerException("OFStatV6Ver15: property oxsFields cannot be null");
        }
        this.oxsFields = oxsFields;
    }

    @Override
    public OFOxsList getOxsFields() {
        return this.oxsFields;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public <F extends OFValueType<F>> F get(StatField<F> field) throws UnsupportedOperationException {
        if (!this.supports(field)) {
            throw new UnsupportedOperationException("OFStatV6Ver15 does not support statistics on field " + field.getName());
        }
        OFOxs<F> oxs = this.oxsFields.get(field);
        if (oxs == null) {
            return null;
        }
        return oxs.getValue();
    }

    @Override
    public Iterable<StatField<?>> getStatFields() {
        return new Iterable<StatField<?>>(){

            @Override
            public Iterator<StatField<?>> iterator() {
                return new StatFieldIterator();
            }
        };
    }

    @Override
    public boolean supports(StatField<?> field) {
        return OFStatV6Ver15.supportsField(field);
    }

    private static boolean supportsField(StatField<?> field) {
        switch (field.id) {
            case BYTE_COUNT: 
            case DURATION: 
            case FLOW_COUNT: 
            case IDLE_TIME: 
            case PACKET_COUNT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public OFStatV6.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFStatV6Ver15(");
        b.append("oxsFields=").append(this.oxsFields);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFStatV6Ver15 other = (OFStatV6Ver15)obj;
        return !(this.oxsFields == null ? other.oxsFields != null : !this.oxsFields.equals(other.oxsFields));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxsFields == null ? 0 : this.oxsFields.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFStatV6Ver15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFStatV6Ver15 message) {
            int startIndex = bb.writerIndex();
            bb.writeZero(2);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.oxsFields.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFStatV6Ver15Funnel
    implements Funnel<OFStatV6Ver15> {
        private static final long serialVersionUID = 1L;

        OFStatV6Ver15Funnel() {
        }

        public void funnel(OFStatV6Ver15 message, PrimitiveSink sink) {
            message.oxsFields.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFStatV6> {
        Reader() {
        }

        @Override
        public OFStatV6 readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            bb.skipBytes(2);
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFOxsList oxsFields = OFOxsList.readFrom(bb, length - (bb.readerIndex() - start), OFOxsVer15.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFStatV6Ver15 statV6Ver15 = new OFStatV6Ver15(oxsFields);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)statV6Ver15);
            }
            return statV6Ver15;
        }
    }

    static class Builder
    implements OFStatV6.Builder {
        private boolean oxsFieldsSet;
        private OFOxsList oxsFields;
        private OFOxsList.Builder oxsFieldsBuilder;

        Builder() {
        }

        @Override
        public OFOxsList getOxsFields() {
            return this.oxsFields;
        }

        @Override
        public OFStatV6.Builder setOxsFields(OFOxsList oxsFields) {
            this.oxsFields = oxsFields;
            this.oxsFieldsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFStatV6 build() {
            OFOxsList oxsFields;
            OFOxsList oFOxsList = oxsFields = this.oxsFieldsSet ? this.oxsFields : DEFAULT_OXS_FIELDS;
            if (oxsFields == null) {
                throw new NullPointerException("Property oxsFields must not be null");
            }
            return new OFStatV6Ver15(oxsFields);
        }

        private void initBuilder() {
            if (this.oxsFieldsBuilder != null) {
                return;
            }
            this.oxsFieldsBuilder = new OFOxsList.Builder();
        }

        private void updateOxsList() {
            this.oxsFields = this.oxsFieldsBuilder.build();
            this.oxsFieldsSet = true;
        }

        @Override
        public <F extends OFValueType<F>> F get(StatField<F> field) throws UnsupportedOperationException {
            if (!this.supports(field)) {
                throw new UnsupportedOperationException("OFStatV6Ver15 does not support statistics on field " + field.getName());
            }
            OFOxs<F> oxs = this.getOxs(field);
            if (oxs == null) {
                return null;
            }
            return oxs.getValue();
        }

        @Override
        public <F extends OFValueType<F>> Stat.Builder set(StatField<F> field, F value) {
            this.initBuilder();
            OFOxs<F> oxs = OFFactories.getFactory(OFVersion.OF_15).oxss().fromValue(value, field);
            this.oxsFieldsBuilder.set(oxs);
            this.updateOxsList();
            return this;
        }

        @Override
        public boolean supports(StatField<?> field) {
            return OFStatV6Ver15.supportsField(field);
        }

        private <F extends OFValueType<F>> OFOxs<F> getOxs(StatField<F> field) {
            return this.oxsFieldsSet ? this.oxsFields.get(field) : null;
        }
    }

    static class BuilderWithParent
    implements OFStatV6.Builder {
        final OFStatV6Ver15 parentMessage;
        private boolean oxsFieldsSet;
        private OFOxsList oxsFields;
        private OFOxsList.Builder oxsFieldsBuilder;

        BuilderWithParent(OFStatV6Ver15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFOxsList getOxsFields() {
            return this.oxsFields;
        }

        @Override
        public OFStatV6.Builder setOxsFields(OFOxsList oxsFields) {
            this.oxsFields = oxsFields;
            this.oxsFieldsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFStatV6 build() {
            OFOxsList oxsFields;
            OFOxsList oFOxsList = oxsFields = this.oxsFieldsSet ? this.oxsFields : this.parentMessage.oxsFields;
            if (oxsFields == null) {
                throw new NullPointerException("Property oxsFields must not be null");
            }
            return new OFStatV6Ver15(oxsFields);
        }

        private void initBuilder() {
            if (this.oxsFieldsBuilder != null) {
                return;
            }
            this.oxsFieldsBuilder = new OFOxsList.Builder();
        }

        private void updateOxsList() {
            this.oxsFields = this.oxsFieldsBuilder.build();
            this.oxsFieldsSet = true;
        }

        @Override
        public <F extends OFValueType<F>> F get(StatField<F> field) throws UnsupportedOperationException {
            if (!this.supports(field)) {
                throw new UnsupportedOperationException("OFStatV6Ver15 does not support statistics on field " + field.getName());
            }
            OFOxs<F> oxs = this.getOxs(field);
            if (oxs == null) {
                return null;
            }
            return oxs.getValue();
        }

        @Override
        public <F extends OFValueType<F>> Stat.Builder set(StatField<F> field, F value) {
            this.initBuilder();
            OFOxs<F> oxs = OFFactories.getFactory(OFVersion.OF_15).oxss().fromValue(value, field);
            this.oxsFieldsBuilder.set(oxs);
            this.updateOxsList();
            return this;
        }

        @Override
        public boolean supports(StatField<?> field) {
            return OFStatV6Ver15.supportsField(field);
        }

        private <F extends OFValueType<F>> OFOxs<F> getOxs(StatField<F> field) {
            return this.oxsFieldsSet ? this.oxsFields.get(field) : null;
        }
    }

    private class StatFieldIterator
    extends AbstractIterator<StatField<?>> {
        private Iterator<OFOxs<?>> oxsIterator;

        StatFieldIterator() {
            this.oxsIterator = OFStatV6Ver15.this.oxsFields.iterator();
        }

        protected StatField<?> computeNext() {
            if (this.oxsIterator.hasNext()) {
                OFOxs<?> oxs = this.oxsIterator.next();
                return oxs.getStatField();
            }
            this.endOfData();
            return null;
        }
    }
}

