/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmPacketTypeMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmPacketTypeVer15;
import org.projectfloodlight.openflow.types.PacketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmPacketTypeMaskedVer15
implements OFOxmPacketTypeMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmPacketTypeMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final PacketType value;
    private final PacketType mask;
    static final Reader READER = new Reader();
    static final OFOxmPacketTypeMaskedVer15Funnel FUNNEL = new OFOxmPacketTypeMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmPacketTypeMaskedVer15(PacketType value, PacketType mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmPacketTypeMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmPacketTypeMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147506440L;
    }

    @Override
    public PacketType getValue() {
        return this.value;
    }

    @Override
    public PacketType getMask() {
        return this.mask;
    }

    @Override
    public MatchField<PacketType> getMatchField() {
        return MatchField.PACKET_TYPE;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<PacketType> getCanonical() {
        if (PacketType.NO_MASK.equals(this.mask)) {
            return new OFOxmPacketTypeVer15(this.value);
        }
        if (PacketType.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmPacketTypeMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmPacketTypeMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmPacketTypeMaskedVer15 other = (OFOxmPacketTypeMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmPacketTypeMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmPacketTypeMaskedVer15 message) {
            bb.writeInt(-2147460856);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmPacketTypeMaskedVer15Funnel
    implements Funnel<OFOxmPacketTypeMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmPacketTypeMaskedVer15Funnel() {
        }

        public void funnel(OFOxmPacketTypeMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147460856);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmPacketTypeMasked> {
        Reader() {
        }

        @Override
        public OFOxmPacketTypeMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147460856) {
                throw new OFParseError("Wrong typeLen: Expected=0x80005908L(0x80005908L), got=" + typeLen);
            }
            PacketType value = PacketType.read4Bytes(bb);
            PacketType mask = PacketType.read4Bytes(bb);
            OFOxmPacketTypeMaskedVer15 oxmPacketTypeMaskedVer15 = new OFOxmPacketTypeMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmPacketTypeMaskedVer15);
            }
            return oxmPacketTypeMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmPacketTypeMasked.Builder {
        private boolean valueSet;
        private PacketType value;
        private boolean maskSet;
        private PacketType mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147506440L;
        }

        @Override
        public PacketType getValue() {
            return this.value;
        }

        @Override
        public OFOxmPacketTypeMasked.Builder setValue(PacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public PacketType getMask() {
            return this.mask;
        }

        @Override
        public OFOxmPacketTypeMasked.Builder setMask(PacketType mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<PacketType> getMatchField() {
            return MatchField.PACKET_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<PacketType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmPacketTypeMasked build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            if (!this.maskSet) {
                throw new IllegalStateException("Property mask doesn't have default value -- must be set");
            }
            if (this.mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmPacketTypeMaskedVer15(this.value, this.mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmPacketTypeMasked.Builder {
        final OFOxmPacketTypeMaskedVer15 parentMessage;
        private boolean valueSet;
        private PacketType value;
        private boolean maskSet;
        private PacketType mask;

        BuilderWithParent(OFOxmPacketTypeMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147506440L;
        }

        @Override
        public PacketType getValue() {
            return this.value;
        }

        @Override
        public OFOxmPacketTypeMasked.Builder setValue(PacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public PacketType getMask() {
            return this.mask;
        }

        @Override
        public OFOxmPacketTypeMasked.Builder setMask(PacketType mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<PacketType> getMatchField() {
            return MatchField.PACKET_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<PacketType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmPacketTypeMasked build() {
            PacketType mask;
            PacketType value;
            PacketType packetType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            PacketType packetType2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmPacketTypeMaskedVer15(value, mask);
        }
    }
}

