/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVrfMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmBsnVrfVer15;
import org.projectfloodlight.openflow.types.VRF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVrfMaskedVer15
implements OFOxmBsnVrfMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVrfMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final VRF DEFAULT_VALUE = VRF.ZERO;
    private static final VRF DEFAULT_VALUE_MASK = VRF.ZERO;
    private final VRF value;
    private final VRF mask;
    static final OFOxmBsnVrfMaskedVer15 DEFAULT = new OFOxmBsnVrfMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnVrfMaskedVer15Funnel FUNNEL = new OFOxmBsnVrfMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVrfMaskedVer15(VRF value, VRF mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVrfMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnVrfMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 197896L;
    }

    @Override
    public VRF getValue() {
        return this.value;
    }

    @Override
    public VRF getMask() {
        return this.mask;
    }

    @Override
    public MatchField<VRF> getMatchField() {
        return MatchField.BSN_VRF;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<VRF> getCanonical() {
        if (VRF.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnVrfVer15(this.value);
        }
        if (VRF.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnVrfMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVrfMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVrfMaskedVer15 other = (OFOxmBsnVrfMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVrfMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVrfMaskedVer15 message) {
            bb.writeInt(197896);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVrfMaskedVer15Funnel
    implements Funnel<OFOxmBsnVrfMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVrfMaskedVer15Funnel() {
        }

        public void funnel(OFOxmBsnVrfMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(197896);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVrfMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnVrfMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197896) {
                throw new OFParseError("Wrong typeLen: Expected=0x30508L(0x30508L), got=" + typeLen);
            }
            VRF value = VRF.read4Bytes(bb);
            VRF mask = VRF.read4Bytes(bb);
            OFOxmBsnVrfMaskedVer15 oxmBsnVrfMaskedVer15 = new OFOxmBsnVrfMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVrfMaskedVer15);
            }
            return oxmBsnVrfMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmBsnVrfMasked.Builder {
        private boolean valueSet;
        private VRF value;
        private boolean maskSet;
        private VRF mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197896L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VRF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setMask(VRF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnVrfMasked build() {
            VRF mask;
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VRF vRF2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVrfMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVrfMasked.Builder {
        final OFOxmBsnVrfMaskedVer15 parentMessage;
        private boolean valueSet;
        private VRF value;
        private boolean maskSet;
        private VRF mask;

        BuilderWithParent(OFOxmBsnVrfMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197896L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VRF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVrfMasked.Builder setMask(VRF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnVrfMasked build() {
            VRF mask;
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VRF vRF2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVrfMaskedVer15(value, mask);
        }
    }
}

