/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf1;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf1Ver15
implements OFOxmBsnUdf1 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf1Ver15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private final UDF value;
    static final OFOxmBsnUdf1Ver15 DEFAULT = new OFOxmBsnUdf1Ver15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf1Ver15Funnel FUNNEL = new OFOxmBsnUdf1Ver15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf1Ver15(UDF value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf1Ver15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 201220L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF1;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        return this;
    }

    @Override
    public UDF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnUdf1.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf1Ver15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf1Ver15 other = (OFOxmBsnUdf1Ver15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf1Ver15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf1Ver15 message) {
            bb.writeInt(201220);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf1Ver15Funnel
    implements Funnel<OFOxmBsnUdf1Ver15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf1Ver15Funnel() {
        }

        public void funnel(OFOxmBsnUdf1Ver15 message, PrimitiveSink sink) {
            sink.putInt(201220);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf1> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf1 readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 201220) {
                throw new OFParseError("Wrong typeLen: Expected=0x31204L(0x31204L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            OFOxmBsnUdf1Ver15 oxmBsnUdf1Ver15 = new OFOxmBsnUdf1Ver15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf1Ver15);
            }
            return oxmBsnUdf1Ver15;
        }
    }

    static class Builder
    implements OFOxmBsnUdf1.Builder {
        private boolean valueSet;
        private UDF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 201220L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf1.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF1;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnUdf1 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf1Ver15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf1.Builder {
        final OFOxmBsnUdf1Ver15 parentMessage;
        private boolean valueSet;
        private UDF value;

        BuilderWithParent(OFOxmBsnUdf1Ver15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 201220L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf1.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF1;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnUdf1 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf1Ver15(value);
        }
    }
}

