/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpOp;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpOpVer15
implements OFOxmArpOp {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpOpVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final ArpOpcode DEFAULT_VALUE = ArpOpcode.NONE;
    private final ArpOpcode value;
    static final OFOxmArpOpVer15 DEFAULT = new OFOxmArpOpVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmArpOpVer15Funnel FUNNEL = new OFOxmArpOpVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpOpVer15(ArpOpcode value) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpOpVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147494402L;
    }

    @Override
    public ArpOpcode getValue() {
        return this.value;
    }

    @Override
    public MatchField<ArpOpcode> getMatchField() {
        return MatchField.ARP_OP;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ArpOpcode> getCanonical() {
        return this;
    }

    @Override
    public ArpOpcode getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmArpOp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpOpVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpOpVer15 other = (OFOxmArpOpVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpOpVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmArpOpVer15 message) {
            bb.writeInt(-2147472894);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmArpOpVer15Funnel
    implements Funnel<OFOxmArpOpVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmArpOpVer15Funnel() {
        }

        public void funnel(OFOxmArpOpVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147472894);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpOp> {
        Reader() {
        }

        @Override
        public OFOxmArpOp readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147472894) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002a02L(0x80002a02L), got=" + typeLen);
            }
            ArpOpcode value = ArpOpcode.read2Bytes(bb);
            OFOxmArpOpVer15 oxmArpOpVer15 = new OFOxmArpOpVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpOpVer15);
            }
            return oxmArpOpVer15;
        }
    }

    static class Builder
    implements OFOxmArpOp.Builder {
        private boolean valueSet;
        private ArpOpcode value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147494402L;
        }

        @Override
        public ArpOpcode getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpOp.Builder setValue(ArpOpcode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ArpOpcode> getMatchField() {
            return MatchField.ARP_OP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ArpOpcode> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public ArpOpcode getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmArpOp build() {
            ArpOpcode value;
            ArpOpcode arpOpcode = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpOpVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpOp.Builder {
        final OFOxmArpOpVer15 parentMessage;
        private boolean valueSet;
        private ArpOpcode value;

        BuilderWithParent(OFOxmArpOpVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147494402L;
        }

        @Override
        public ArpOpcode getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpOp.Builder setValue(ArpOpcode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ArpOpcode> getMatchField() {
            return MatchField.ARP_OP;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ArpOpcode> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public ArpOpcode getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmArpOp build() {
            ArpOpcode value;
            ArpOpcode arpOpcode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpOpVer15(value);
        }
    }
}

