/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterConfig;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBand;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterBandVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterConfigVer15
implements OFMeterConfig {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterConfigVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    private static final Set<OFMeterFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_METER_ID = 0L;
    private static final List<OFMeterBand> DEFAULT_ENTRIES = ImmutableList.of();
    private final Set<OFMeterFlags> flags;
    private final long meterId;
    private final List<OFMeterBand> entries;
    static final OFMeterConfigVer15 DEFAULT = new OFMeterConfigVer15(DEFAULT_FLAGS, 0L, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFMeterConfigVer15Funnel FUNNEL = new OFMeterConfigVer15Funnel();
    static final Writer WRITER = new Writer();

    OFMeterConfigVer15(Set<OFMeterFlags> flags, long meterId, List<OFMeterBand> entries) {
        if (flags == null) {
            throw new NullPointerException("OFMeterConfigVer15: property flags cannot be null");
        }
        if (entries == null) {
            throw new NullPointerException("OFMeterConfigVer15: property entries cannot be null");
        }
        this.flags = flags;
        this.meterId = meterId;
        this.entries = entries;
    }

    @Override
    public Set<OFMeterFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public List<OFMeterBand> getEntries() {
        return this.entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFMeterConfig.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterConfigVer15(");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("meterId=").append(this.meterId);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterConfigVer15 other = (OFMeterConfigVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.meterId != other.meterId) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterConfigVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterConfigVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            OFMeterFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeInt(U32.t(message.meterId));
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFMeterConfigVer15Funnel
    implements Funnel<OFMeterConfigVer15> {
        private static final long serialVersionUID = 1L;

        OFMeterConfigVer15Funnel() {
        }

        public void funnel(OFMeterConfigVer15 message, PrimitiveSink sink) {
            OFMeterFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putLong(message.meterId);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterConfig> {
        Reader() {
        }

        @Override
        public OFMeterConfig readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFMeterFlags> flags = OFMeterFlagsSerializerVer15.readFrom(bb);
            long meterId = U32.f(bb.readInt());
            List<OFMeterBand> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFMeterBandVer15.READER);
            OFMeterConfigVer15 meterConfigVer15 = new OFMeterConfigVer15(flags, meterId, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterConfigVer15);
            }
            return meterConfigVer15;
        }
    }

    static class Builder
    implements OFMeterConfig.Builder {
        private boolean flagsSet;
        private Set<OFMeterFlags> flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean entriesSet;
        private List<OFMeterBand> entries;

        Builder() {
        }

        @Override
        public Set<OFMeterFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterConfig.Builder setFlags(Set<OFMeterFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterConfig.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getEntries() {
            return this.entries;
        }

        @Override
        public OFMeterConfig.Builder setEntries(List<OFMeterBand> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFMeterConfig build() {
            List<OFMeterBand> entries;
            Set<OFMeterFlags> flags;
            Set<OFMeterFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : 0L;
            List<OFMeterBand> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFMeterConfigVer15(flags, meterId, entries);
        }
    }

    static class BuilderWithParent
    implements OFMeterConfig.Builder {
        final OFMeterConfigVer15 parentMessage;
        private boolean flagsSet;
        private Set<OFMeterFlags> flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean entriesSet;
        private List<OFMeterBand> entries;

        BuilderWithParent(OFMeterConfigVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public Set<OFMeterFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterConfig.Builder setFlags(Set<OFMeterFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterConfig.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getEntries() {
            return this.entries;
        }

        @Override
        public OFMeterConfig.Builder setEntries(List<OFMeterBand> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFMeterConfig build() {
            List entries;
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFMeterConfigVer15(flags, meterId, entries);
        }
    }
}

