/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;

public class OFInstructionTypeSerializerVer15 {
    public static final short GOTO_TABLE_VAL = 1;
    public static final short WRITE_METADATA_VAL = 2;
    public static final short WRITE_ACTIONS_VAL = 3;
    public static final short APPLY_ACTIONS_VAL = 4;
    public static final short CLEAR_ACTIONS_VAL = 5;
    public static final short EXPERIMENTER_VAL = -1;
    public static final short DEPRECATED_VAL = 6;
    public static final short STAT_TRIGGER_VAL = 7;

    public static Set<OFInstructionType> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFInstructionTypeSerializerVer15.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFInstructionType> set) {
        bb.writeShort((int)OFInstructionTypeSerializerVer15.toWireValue(set));
    }

    public static void putTo(Set<OFInstructionType> set, PrimitiveSink sink) {
        sink.putShort(OFInstructionTypeSerializerVer15.toWireValue(set));
    }

    public static Set<OFInstructionType> ofWireValue(short val) {
        EnumSet<OFInstructionType> set = EnumSet.noneOf(OFInstructionType.class);
        if ((val & 1) != 0) {
            set.add(OFInstructionType.GOTO_TABLE);
        }
        if ((val & 2) != 0) {
            set.add(OFInstructionType.WRITE_METADATA);
        }
        if ((val & 3) != 0) {
            set.add(OFInstructionType.WRITE_ACTIONS);
        }
        if ((val & 4) != 0) {
            set.add(OFInstructionType.APPLY_ACTIONS);
        }
        if ((val & 5) != 0) {
            set.add(OFInstructionType.CLEAR_ACTIONS);
        }
        if ((val & 0xFFFFFFFF) != 0) {
            set.add(OFInstructionType.EXPERIMENTER);
        }
        if ((val & 6) != 0) {
            set.add(OFInstructionType.DEPRECATED);
        }
        if ((val & 7) != 0) {
            set.add(OFInstructionType.STAT_TRIGGER);
        }
        return Collections.unmodifiableSet(set);
    }

    public static short toWireValue(Set<OFInstructionType> set) {
        short wireValue = 0;
        block10: for (OFInstructionType e : set) {
            switch (e) {
                case GOTO_TABLE: {
                    wireValue = (short)(wireValue | 1);
                    continue block10;
                }
                case WRITE_METADATA: {
                    wireValue = (short)(wireValue | 2);
                    continue block10;
                }
                case WRITE_ACTIONS: {
                    wireValue = (short)(wireValue | 3);
                    continue block10;
                }
                case APPLY_ACTIONS: {
                    wireValue = (short)(wireValue | 4);
                    continue block10;
                }
                case CLEAR_ACTIONS: {
                    wireValue = (short)(wireValue | 5);
                    continue block10;
                }
                case EXPERIMENTER: {
                    wireValue = (short)(wireValue | 0xFFFFFFFF);
                    continue block10;
                }
                case DEPRECATED: {
                    wireValue = (short)(wireValue | 6);
                    continue block10;
                }
                case STAT_TRIGGER: {
                    wireValue = (short)(wireValue | 7);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFInstructionType in version 1.5: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

