/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsnAutoNegotiation;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionBsnAutoNegotiationVer15
implements OFInstructionBsnAutoNegotiation {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionBsnAutoNegotiationVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 16;
    static final OFInstructionBsnAutoNegotiationVer15 DEFAULT = new OFInstructionBsnAutoNegotiationVer15();
    static final OFInstructionBsnAutoNegotiationVer15 INSTANCE = new OFInstructionBsnAutoNegotiationVer15();
    static final Reader READER = new Reader();
    static final OFInstructionBsnAutoNegotiationVer15Funnel FUNNEL = new OFInstructionBsnAutoNegotiationVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionBsnAutoNegotiationVer15() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 11L;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFInstructionBsnAutoNegotiation.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionBsnAutoNegotiationVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionBsnAutoNegotiationVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionBsnAutoNegotiationVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionBsnAutoNegotiationVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(11);
            bb.writeZero(4);
        }
    }

    static class OFInstructionBsnAutoNegotiationVer15Funnel
    implements Funnel<OFInstructionBsnAutoNegotiationVer15> {
        private static final long serialVersionUID = 1L;

        OFInstructionBsnAutoNegotiationVer15Funnel() {
        }

        public void funnel(OFInstructionBsnAutoNegotiationVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(11);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionBsnAutoNegotiation> {
        Reader() {
        }

        @Override
        public OFInstructionBsnAutoNegotiation readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 11) {
                throw new OFParseError("Wrong subtype: Expected=0xbL(0xbL), got=" + subtype);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

