/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFGroupModFailedCode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFGroupModFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupModFailedCodeSerializerVer15;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupModFailedErrorMsgVer15
implements OFGroupModFailedErrorMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupModFailedErrorMsgVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final OFGroupModFailedCode code;
    private final OFErrorCauseData data;
    static final Reader READER = new Reader();
    static final OFGroupModFailedErrorMsgVer15Funnel FUNNEL = new OFGroupModFailedErrorMsgVer15Funnel();
    static final Writer WRITER = new Writer();

    OFGroupModFailedErrorMsgVer15(long xid, OFGroupModFailedCode code, OFErrorCauseData data) {
        if (code == null) {
            throw new NullPointerException("OFGroupModFailedErrorMsgVer15: property code cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFGroupModFailedErrorMsgVer15: property data cannot be null");
        }
        this.xid = xid;
        this.code = code;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.GROUP_MOD_FAILED;
    }

    @Override
    public OFGroupModFailedCode getCode() {
        return this.code;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFGroupModFailedErrorMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupModFailedErrorMsgVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("code=").append((Object)this.code);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupModFailedErrorMsgVer15 other = (OFGroupModFailedErrorMsgVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupModFailedErrorMsgVer15 other = (OFGroupModFailedErrorMsgVer15)obj;
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupModFailedErrorMsgVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupModFailedErrorMsgVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(6);
            OFGroupModFailedCodeSerializerVer15.writeTo(bb, message.code);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupModFailedErrorMsgVer15Funnel
    implements Funnel<OFGroupModFailedErrorMsgVer15> {
        private static final long serialVersionUID = 1L;

        OFGroupModFailedErrorMsgVer15Funnel() {
        }

        public void funnel(OFGroupModFailedErrorMsgVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)6);
            OFGroupModFailedCodeSerializerVer15.putTo(message.code, sink);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupModFailedErrorMsg> {
        Reader() {
        }

        @Override
        public OFGroupModFailedErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != 6) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.GROUP_MOD_FAILED(6), got=" + errType);
            }
            OFGroupModFailedCode code = OFGroupModFailedCodeSerializerVer15.readFrom(bb);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_15);
            OFGroupModFailedErrorMsgVer15 groupModFailedErrorMsgVer15 = new OFGroupModFailedErrorMsgVer15(xid, code, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupModFailedErrorMsgVer15);
            }
            return groupModFailedErrorMsgVer15;
        }
    }

    static class Builder
    implements OFGroupModFailedErrorMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFGroupModFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupModFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.GROUP_MOD_FAILED;
        }

        @Override
        public OFGroupModFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFGroupModFailedErrorMsg.Builder setCode(OFGroupModFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFGroupModFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFGroupModFailedErrorMsg build() {
            OFErrorCauseData data;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.codeSet) {
                throw new IllegalStateException("Property code doesn't have default value -- must be set");
            }
            if (this.code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFGroupModFailedErrorMsgVer15(xid, this.code, data);
        }
    }

    static class BuilderWithParent
    implements OFGroupModFailedErrorMsg.Builder {
        final OFGroupModFailedErrorMsgVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFGroupModFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFGroupModFailedErrorMsgVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupModFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.GROUP_MOD_FAILED;
        }

        @Override
        public OFGroupModFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFGroupModFailedErrorMsg.Builder setCode(OFGroupModFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFGroupModFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFGroupModFailedErrorMsg build() {
            OFErrorCauseData data;
            OFGroupModFailedCode code;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFGroupModFailedCode oFGroupModFailedCode = code = this.codeSet ? this.code : this.parentMessage.code;
            if (code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFGroupModFailedErrorMsgVer15(xid, code, data);
        }
    }
}

