/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControlChannelStatus;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFControllerStatusEntry;
import org.projectfloodlight.openflow.protocol.OFControllerStatusProp;
import org.projectfloodlight.openflow.protocol.OFControllerStatusReason;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFControlChannelStatusSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerRoleSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFControllerStatusReasonSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFControllerStatusEntryVer15
implements OFControllerStatusEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFControllerStatusEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final int DEFAULT_SHORT_ID = 0;
    private static final List<OFControllerStatusProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final int shortId;
    private final OFControllerRole role;
    private final OFControllerStatusReason reason;
    private final OFControlChannelStatus channelStatus;
    private final List<OFControllerStatusProp> properties;
    static final Reader READER = new Reader();
    static final OFControllerStatusEntryVer15Funnel FUNNEL = new OFControllerStatusEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFControllerStatusEntryVer15(int shortId, OFControllerRole role, OFControllerStatusReason reason, OFControlChannelStatus channelStatus, List<OFControllerStatusProp> properties) {
        if (role == null) {
            throw new NullPointerException("OFControllerStatusEntryVer15: property role cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFControllerStatusEntryVer15: property reason cannot be null");
        }
        if (channelStatus == null) {
            throw new NullPointerException("OFControllerStatusEntryVer15: property channelStatus cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFControllerStatusEntryVer15: property properties cannot be null");
        }
        this.shortId = shortId;
        this.role = role;
        this.reason = reason;
        this.channelStatus = channelStatus;
        this.properties = properties;
    }

    @Override
    public int getShortId() {
        return this.shortId;
    }

    @Override
    public OFControllerRole getRole() {
        return this.role;
    }

    @Override
    public OFControllerStatusReason getReason() {
        return this.reason;
    }

    @Override
    public OFControlChannelStatus getChannelStatus() {
        return this.channelStatus;
    }

    @Override
    public List<OFControllerStatusProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFControllerStatusEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFControllerStatusEntryVer15(");
        b.append("shortId=").append(this.shortId);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("channelStatus=").append((Object)this.channelStatus);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFControllerStatusEntryVer15 other = (OFControllerStatusEntryVer15)obj;
        if (this.shortId != other.shortId) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.channelStatus == null ? other.channelStatus != null : !this.channelStatus.equals((Object)other.channelStatus)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.shortId;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.channelStatus == null ? 0 : this.channelStatus.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFControllerStatusEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFControllerStatusEntryVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeShort((int)U16.t(message.shortId));
            OFControllerRoleSerializerVer15.writeTo(bb, message.role);
            OFControllerStatusReasonSerializerVer15.writeTo(bb, message.reason);
            OFControlChannelStatusSerializerVer15.writeTo(bb, message.channelStatus);
            bb.writeZero(6);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFControllerStatusEntryVer15Funnel
    implements Funnel<OFControllerStatusEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFControllerStatusEntryVer15Funnel() {
        }

        public void funnel(OFControllerStatusEntryVer15 message, PrimitiveSink sink) {
            sink.putInt(message.shortId);
            OFControllerRoleSerializerVer15.putTo(message.role, sink);
            OFControllerStatusReasonSerializerVer15.putTo(message.reason, sink);
            OFControlChannelStatusSerializerVer15.putTo(message.channelStatus, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFControllerStatusEntry> {
        Reader() {
        }

        @Override
        public OFControllerStatusEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int shortId = U16.f(bb.readShort());
            OFControllerRole role = OFControllerRoleSerializerVer15.readFrom(bb);
            OFControllerStatusReason reason = OFControllerStatusReasonSerializerVer15.readFrom(bb);
            OFControlChannelStatus channelStatus = OFControlChannelStatusSerializerVer15.readFrom(bb);
            bb.skipBytes(6);
            List<OFControllerStatusProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFControllerStatusPropVer15.READER);
            OFControllerStatusEntryVer15 controllerStatusEntryVer15 = new OFControllerStatusEntryVer15(shortId, role, reason, channelStatus, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)controllerStatusEntryVer15);
            }
            return controllerStatusEntryVer15;
        }
    }

    static class Builder
    implements OFControllerStatusEntry.Builder {
        private boolean shortIdSet;
        private int shortId;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean reasonSet;
        private OFControllerStatusReason reason;
        private boolean channelStatusSet;
        private OFControlChannelStatus channelStatus;
        private boolean propertiesSet;
        private List<OFControllerStatusProp> properties;

        Builder() {
        }

        @Override
        public int getShortId() {
            return this.shortId;
        }

        @Override
        public OFControllerStatusEntry.Builder setShortId(int shortId) {
            this.shortId = shortId;
            this.shortIdSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFControllerStatusEntry.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFControllerStatusReason getReason() {
            return this.reason;
        }

        @Override
        public OFControllerStatusEntry.Builder setReason(OFControllerStatusReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFControlChannelStatus getChannelStatus() {
            return this.channelStatus;
        }

        @Override
        public OFControllerStatusEntry.Builder setChannelStatus(OFControlChannelStatus channelStatus) {
            this.channelStatus = channelStatus;
            this.channelStatusSet = true;
            return this;
        }

        @Override
        public List<OFControllerStatusProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFControllerStatusEntry.Builder setProperties(List<OFControllerStatusProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFControllerStatusEntry build() {
            List<OFControllerStatusProp> properties;
            int shortId;
            int n = shortId = this.shortIdSet ? this.shortId : 0;
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            if (!this.channelStatusSet) {
                throw new IllegalStateException("Property channelStatus doesn't have default value -- must be set");
            }
            if (this.channelStatus == null) {
                throw new NullPointerException("Property channelStatus must not be null");
            }
            List<OFControllerStatusProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFControllerStatusEntryVer15(shortId, this.role, this.reason, this.channelStatus, properties);
        }
    }

    static class BuilderWithParent
    implements OFControllerStatusEntry.Builder {
        final OFControllerStatusEntryVer15 parentMessage;
        private boolean shortIdSet;
        private int shortId;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean reasonSet;
        private OFControllerStatusReason reason;
        private boolean channelStatusSet;
        private OFControlChannelStatus channelStatus;
        private boolean propertiesSet;
        private List<OFControllerStatusProp> properties;

        BuilderWithParent(OFControllerStatusEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getShortId() {
            return this.shortId;
        }

        @Override
        public OFControllerStatusEntry.Builder setShortId(int shortId) {
            this.shortId = shortId;
            this.shortIdSet = true;
            return this;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFControllerStatusEntry.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFControllerStatusReason getReason() {
            return this.reason;
        }

        @Override
        public OFControllerStatusEntry.Builder setReason(OFControllerStatusReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFControlChannelStatus getChannelStatus() {
            return this.channelStatus;
        }

        @Override
        public OFControllerStatusEntry.Builder setChannelStatus(OFControlChannelStatus channelStatus) {
            this.channelStatus = channelStatus;
            this.channelStatusSet = true;
            return this;
        }

        @Override
        public List<OFControllerStatusProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFControllerStatusEntry.Builder setProperties(List<OFControllerStatusProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFControllerStatusEntry build() {
            List properties;
            OFControlChannelStatus channelStatus;
            OFControllerStatusReason reason;
            OFControllerRole role;
            int shortId = this.shortIdSet ? this.shortId : this.parentMessage.shortId;
            OFControllerRole oFControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            OFControllerStatusReason oFControllerStatusReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFControlChannelStatus oFControlChannelStatus = channelStatus = this.channelStatusSet ? this.channelStatus : this.parentMessage.channelStatus;
            if (channelStatus == null) {
                throw new NullPointerException("Property channelStatus must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFControllerStatusEntryVer15(shortId, role, reason, channelStatus, properties);
        }
    }
}

