/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleFeaturesPropTime;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTime;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFTimeVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleFeaturesPropTimeVer15
implements OFBundleFeaturesPropTime {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleFeaturesPropTimeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 72;
    private final OFTime schedAccuracy;
    private final OFTime schedMaxFuture;
    private final OFTime schedMaxPast;
    private final OFTime timestamp;
    static final Reader READER = new Reader();
    static final OFBundleFeaturesPropTimeVer15Funnel FUNNEL = new OFBundleFeaturesPropTimeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBundleFeaturesPropTimeVer15(OFTime schedAccuracy, OFTime schedMaxFuture, OFTime schedMaxPast, OFTime timestamp) {
        if (schedAccuracy == null) {
            throw new NullPointerException("OFBundleFeaturesPropTimeVer15: property schedAccuracy cannot be null");
        }
        if (schedMaxFuture == null) {
            throw new NullPointerException("OFBundleFeaturesPropTimeVer15: property schedMaxFuture cannot be null");
        }
        if (schedMaxPast == null) {
            throw new NullPointerException("OFBundleFeaturesPropTimeVer15: property schedMaxPast cannot be null");
        }
        if (timestamp == null) {
            throw new NullPointerException("OFBundleFeaturesPropTimeVer15: property timestamp cannot be null");
        }
        this.schedAccuracy = schedAccuracy;
        this.schedMaxFuture = schedMaxFuture;
        this.schedMaxPast = schedMaxPast;
        this.timestamp = timestamp;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public OFTime getSchedAccuracy() {
        return this.schedAccuracy;
    }

    @Override
    public OFTime getSchedMaxFuture() {
        return this.schedMaxFuture;
    }

    @Override
    public OFTime getSchedMaxPast() {
        return this.schedMaxPast;
    }

    @Override
    public OFTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBundleFeaturesPropTime.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleFeaturesPropTimeVer15(");
        b.append("schedAccuracy=").append(this.schedAccuracy);
        b.append(", ");
        b.append("schedMaxFuture=").append(this.schedMaxFuture);
        b.append(", ");
        b.append("schedMaxPast=").append(this.schedMaxPast);
        b.append(", ");
        b.append("timestamp=").append(this.timestamp);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleFeaturesPropTimeVer15 other = (OFBundleFeaturesPropTimeVer15)obj;
        if (this.schedAccuracy == null ? other.schedAccuracy != null : !this.schedAccuracy.equals(other.schedAccuracy)) {
            return false;
        }
        if (this.schedMaxFuture == null ? other.schedMaxFuture != null : !this.schedMaxFuture.equals(other.schedMaxFuture)) {
            return false;
        }
        if (this.schedMaxPast == null ? other.schedMaxPast != null : !this.schedMaxPast.equals(other.schedMaxPast)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schedAccuracy == null ? 0 : this.schedAccuracy.hashCode());
        result = 31 * result + (this.schedMaxFuture == null ? 0 : this.schedMaxFuture.hashCode());
        result = 31 * result + (this.schedMaxPast == null ? 0 : this.schedMaxPast.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleFeaturesPropTimeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundleFeaturesPropTimeVer15 message) {
            bb.writeShort(1);
            bb.writeShort(72);
            bb.writeZero(4);
            message.schedAccuracy.writeTo(bb);
            message.schedMaxFuture.writeTo(bb);
            message.schedMaxPast.writeTo(bb);
            message.timestamp.writeTo(bb);
        }
    }

    static class OFBundleFeaturesPropTimeVer15Funnel
    implements Funnel<OFBundleFeaturesPropTimeVer15> {
        private static final long serialVersionUID = 1L;

        OFBundleFeaturesPropTimeVer15Funnel() {
        }

        public void funnel(OFBundleFeaturesPropTimeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)72);
            message.schedAccuracy.putTo(sink);
            message.schedMaxFuture.putTo(sink);
            message.schedMaxPast.putTo(sink);
            message.timestamp.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleFeaturesPropTime> {
        Reader() {
        }

        @Override
        public OFBundleFeaturesPropTime readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 72) {
                throw new OFParseError("Wrong length: Expected=72(72), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            OFTime schedAccuracy = OFTimeVer15.READER.readFrom(bb);
            OFTime schedMaxFuture = OFTimeVer15.READER.readFrom(bb);
            OFTime schedMaxPast = OFTimeVer15.READER.readFrom(bb);
            OFTime timestamp = OFTimeVer15.READER.readFrom(bb);
            OFBundleFeaturesPropTimeVer15 bundleFeaturesPropTimeVer15 = new OFBundleFeaturesPropTimeVer15(schedAccuracy, schedMaxFuture, schedMaxPast, timestamp);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleFeaturesPropTimeVer15);
            }
            return bundleFeaturesPropTimeVer15;
        }
    }

    static class Builder
    implements OFBundleFeaturesPropTime.Builder {
        private boolean schedAccuracySet;
        private OFTime schedAccuracy;
        private boolean schedMaxFutureSet;
        private OFTime schedMaxFuture;
        private boolean schedMaxPastSet;
        private OFTime schedMaxPast;
        private boolean timestampSet;
        private OFTime timestamp;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public OFTime getSchedAccuracy() {
            return this.schedAccuracy;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setSchedAccuracy(OFTime schedAccuracy) {
            this.schedAccuracy = schedAccuracy;
            this.schedAccuracySet = true;
            return this;
        }

        @Override
        public OFTime getSchedMaxFuture() {
            return this.schedMaxFuture;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setSchedMaxFuture(OFTime schedMaxFuture) {
            this.schedMaxFuture = schedMaxFuture;
            this.schedMaxFutureSet = true;
            return this;
        }

        @Override
        public OFTime getSchedMaxPast() {
            return this.schedMaxPast;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setSchedMaxPast(OFTime schedMaxPast) {
            this.schedMaxPast = schedMaxPast;
            this.schedMaxPastSet = true;
            return this;
        }

        @Override
        public OFTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setTimestamp(OFTime timestamp) {
            this.timestamp = timestamp;
            this.timestampSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBundleFeaturesPropTime build() {
            if (!this.schedAccuracySet) {
                throw new IllegalStateException("Property schedAccuracy doesn't have default value -- must be set");
            }
            if (this.schedAccuracy == null) {
                throw new NullPointerException("Property schedAccuracy must not be null");
            }
            if (!this.schedMaxFutureSet) {
                throw new IllegalStateException("Property schedMaxFuture doesn't have default value -- must be set");
            }
            if (this.schedMaxFuture == null) {
                throw new NullPointerException("Property schedMaxFuture must not be null");
            }
            if (!this.schedMaxPastSet) {
                throw new IllegalStateException("Property schedMaxPast doesn't have default value -- must be set");
            }
            if (this.schedMaxPast == null) {
                throw new NullPointerException("Property schedMaxPast must not be null");
            }
            if (!this.timestampSet) {
                throw new IllegalStateException("Property timestamp doesn't have default value -- must be set");
            }
            if (this.timestamp == null) {
                throw new NullPointerException("Property timestamp must not be null");
            }
            return new OFBundleFeaturesPropTimeVer15(this.schedAccuracy, this.schedMaxFuture, this.schedMaxPast, this.timestamp);
        }
    }

    static class BuilderWithParent
    implements OFBundleFeaturesPropTime.Builder {
        final OFBundleFeaturesPropTimeVer15 parentMessage;
        private boolean schedAccuracySet;
        private OFTime schedAccuracy;
        private boolean schedMaxFutureSet;
        private OFTime schedMaxFuture;
        private boolean schedMaxPastSet;
        private OFTime schedMaxPast;
        private boolean timestampSet;
        private OFTime timestamp;

        BuilderWithParent(OFBundleFeaturesPropTimeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public OFTime getSchedAccuracy() {
            return this.schedAccuracy;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setSchedAccuracy(OFTime schedAccuracy) {
            this.schedAccuracy = schedAccuracy;
            this.schedAccuracySet = true;
            return this;
        }

        @Override
        public OFTime getSchedMaxFuture() {
            return this.schedMaxFuture;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setSchedMaxFuture(OFTime schedMaxFuture) {
            this.schedMaxFuture = schedMaxFuture;
            this.schedMaxFutureSet = true;
            return this;
        }

        @Override
        public OFTime getSchedMaxPast() {
            return this.schedMaxPast;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setSchedMaxPast(OFTime schedMaxPast) {
            this.schedMaxPast = schedMaxPast;
            this.schedMaxPastSet = true;
            return this;
        }

        @Override
        public OFTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public OFBundleFeaturesPropTime.Builder setTimestamp(OFTime timestamp) {
            this.timestamp = timestamp;
            this.timestampSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBundleFeaturesPropTime build() {
            OFTime timestamp;
            OFTime schedMaxPast;
            OFTime schedMaxFuture;
            OFTime schedAccuracy;
            OFTime oFTime = schedAccuracy = this.schedAccuracySet ? this.schedAccuracy : this.parentMessage.schedAccuracy;
            if (schedAccuracy == null) {
                throw new NullPointerException("Property schedAccuracy must not be null");
            }
            OFTime oFTime2 = schedMaxFuture = this.schedMaxFutureSet ? this.schedMaxFuture : this.parentMessage.schedMaxFuture;
            if (schedMaxFuture == null) {
                throw new NullPointerException("Property schedMaxFuture must not be null");
            }
            OFTime oFTime3 = schedMaxPast = this.schedMaxPastSet ? this.schedMaxPast : this.parentMessage.schedMaxPast;
            if (schedMaxPast == null) {
                throw new NullPointerException("Property schedMaxPast must not be null");
            }
            OFTime oFTime4 = timestamp = this.timestampSet ? this.timestamp : this.parentMessage.timestamp;
            if (timestamp == null) {
                throw new NullPointerException("Property timestamp must not be null");
            }
            return new OFBundleFeaturesPropTimeVer15(schedAccuracy, schedMaxFuture, schedMaxPast, timestamp);
        }
    }
}

