/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlMsg;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlType;
import org.projectfloodlight.openflow.protocol.OFBundleFlags;
import org.projectfloodlight.openflow.protocol.OFBundleProp;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleCtrlTypeSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFlagsSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundlePropVer15;
import org.projectfloodlight.openflow.types.BundleId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleCtrlMsgVer15
implements OFBundleCtrlMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleCtrlMsgVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFBundleFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFBundleProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final BundleId bundleId;
    private final OFBundleCtrlType bundleCtrlType;
    private final Set<OFBundleFlags> flags;
    private final List<OFBundleProp> properties;
    static final Reader READER = new Reader();
    static final OFBundleCtrlMsgVer15Funnel FUNNEL = new OFBundleCtrlMsgVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBundleCtrlMsgVer15(long xid, BundleId bundleId, OFBundleCtrlType bundleCtrlType, Set<OFBundleFlags> flags, List<OFBundleProp> properties) {
        if (bundleId == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer15: property bundleId cannot be null");
        }
        if (bundleCtrlType == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer15: property bundleCtrlType cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer15: property flags cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFBundleCtrlMsgVer15: property properties cannot be null");
        }
        this.xid = xid;
        this.bundleId = bundleId;
        this.bundleCtrlType = bundleCtrlType;
        this.flags = flags;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.BUNDLE_CONTROL;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public BundleId getBundleId() {
        return this.bundleId;
    }

    @Override
    public OFBundleCtrlType getBundleCtrlType() {
        return this.bundleCtrlType;
    }

    @Override
    public Set<OFBundleFlags> getFlags() {
        return this.flags;
    }

    @Override
    public List<OFBundleProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFBundleCtrlMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleCtrlMsgVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bundleId=").append(this.bundleId);
        b.append(", ");
        b.append("bundleCtrlType=").append((Object)this.bundleCtrlType);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleCtrlMsgVer15 other = (OFBundleCtrlMsgVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.bundleCtrlType == null ? other.bundleCtrlType != null : !this.bundleCtrlType.equals((Object)other.bundleCtrlType)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleCtrlMsgVer15 other = (OFBundleCtrlMsgVer15)obj;
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.bundleCtrlType == null ? other.bundleCtrlType != null : !this.bundleCtrlType.equals((Object)other.bundleCtrlType)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.bundleCtrlType == null ? 0 : this.bundleCtrlType.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.bundleCtrlType == null ? 0 : this.bundleCtrlType.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleCtrlMsgVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundleCtrlMsgVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(33);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.bundleId.write4Bytes(bb);
            OFBundleCtrlTypeSerializerVer15.writeTo(bb, message.bundleCtrlType);
            OFBundleFlagsSerializerVer15.writeTo(bb, message.flags);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundleCtrlMsgVer15Funnel
    implements Funnel<OFBundleCtrlMsgVer15> {
        private static final long serialVersionUID = 1L;

        OFBundleCtrlMsgVer15Funnel() {
        }

        public void funnel(OFBundleCtrlMsgVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)33);
            sink.putLong(message.xid);
            message.bundleId.putTo(sink);
            OFBundleCtrlTypeSerializerVer15.putTo(message.bundleCtrlType, sink);
            OFBundleFlagsSerializerVer15.putTo(message.flags, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleCtrlMsg> {
        Reader() {
        }

        @Override
        public OFBundleCtrlMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 33) {
                throw new OFParseError("Wrong type: Expected=OFType.BUNDLE_CONTROL(33), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            BundleId bundleId = BundleId.read4Bytes(bb);
            OFBundleCtrlType bundleCtrlType = OFBundleCtrlTypeSerializerVer15.readFrom(bb);
            Set<OFBundleFlags> flags = OFBundleFlagsSerializerVer15.readFrom(bb);
            List<OFBundleProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBundlePropVer15.READER);
            OFBundleCtrlMsgVer15 bundleCtrlMsgVer15 = new OFBundleCtrlMsgVer15(xid, bundleId, bundleCtrlType, flags, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleCtrlMsgVer15);
            }
            return bundleCtrlMsgVer15;
        }
    }

    static class Builder
    implements OFBundleCtrlMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean bundleCtrlTypeSet;
        private OFBundleCtrlType bundleCtrlType;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean propertiesSet;
        private List<OFBundleProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_CONTROL;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleCtrlMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlType getBundleCtrlType() {
            return this.bundleCtrlType;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleCtrlType(OFBundleCtrlType bundleCtrlType) {
            this.bundleCtrlType = bundleCtrlType;
            this.bundleCtrlTypeSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleCtrlMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFBundleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleCtrlMsg.Builder setProperties(List<OFBundleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlMsg build() {
            List<OFBundleProp> properties;
            Set<OFBundleFlags> flags;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.bundleIdSet) {
                throw new IllegalStateException("Property bundleId doesn't have default value -- must be set");
            }
            if (this.bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            if (!this.bundleCtrlTypeSet) {
                throw new IllegalStateException("Property bundleCtrlType doesn't have default value -- must be set");
            }
            if (this.bundleCtrlType == null) {
                throw new NullPointerException("Property bundleCtrlType must not be null");
            }
            Set<OFBundleFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List<OFBundleProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleCtrlMsgVer15(xid, this.bundleId, this.bundleCtrlType, flags, properties);
        }
    }

    static class BuilderWithParent
    implements OFBundleCtrlMsg.Builder {
        final OFBundleCtrlMsgVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean bundleCtrlTypeSet;
        private OFBundleCtrlType bundleCtrlType;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean propertiesSet;
        private List<OFBundleProp> properties;

        BuilderWithParent(OFBundleCtrlMsgVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_CONTROL;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleCtrlMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlType getBundleCtrlType() {
            return this.bundleCtrlType;
        }

        @Override
        public OFBundleCtrlMsg.Builder setBundleCtrlType(OFBundleCtrlType bundleCtrlType) {
            this.bundleCtrlType = bundleCtrlType;
            this.bundleCtrlTypeSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleCtrlMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public List<OFBundleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleCtrlMsg.Builder setProperties(List<OFBundleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleCtrlMsg build() {
            List properties;
            Set flags;
            OFBundleCtrlType bundleCtrlType;
            BundleId bundleId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            BundleId bundleId2 = bundleId = this.bundleIdSet ? this.bundleId : this.parentMessage.bundleId;
            if (bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            OFBundleCtrlType oFBundleCtrlType = bundleCtrlType = this.bundleCtrlTypeSet ? this.bundleCtrlType : this.parentMessage.bundleCtrlType;
            if (bundleCtrlType == null) {
                throw new NullPointerException("Property bundleCtrlType must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleCtrlMsgVer15(xid, bundleId, bundleCtrlType, flags, properties);
        }
    }
}

