/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVlanPcp;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVlanPcpVer15
implements OFBsnTlvVlanPcp {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVlanPcpVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvVlanPcpVer15 DEFAULT = new OFBsnTlvVlanPcpVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvVlanPcpVer15Funnel FUNNEL = new OFBsnTlvVlanPcpVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVlanPcpVer15(short value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 72;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvVlanPcp.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVlanPcpVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVlanPcpVer15 other = (OFBsnTlvVlanPcpVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVlanPcpVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVlanPcpVer15 message) {
            bb.writeShort(72);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvVlanPcpVer15Funnel
    implements Funnel<OFBsnTlvVlanPcpVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVlanPcpVer15Funnel() {
        }

        public void funnel(OFBsnTlvVlanPcpVer15 message, PrimitiveSink sink) {
            sink.putShort((short)72);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVlanPcp> {
        Reader() {
        }

        @Override
        public OFBsnTlvVlanPcp readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 72) {
                throw new OFParseError("Wrong type: Expected=0x48(0x48), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvVlanPcpVer15 bsnTlvVlanPcpVer15 = new OFBsnTlvVlanPcpVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVlanPcpVer15);
            }
            return bsnTlvVlanPcpVer15;
        }
    }

    static class Builder
    implements OFBsnTlvVlanPcp.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 72;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVlanPcp.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvVlanPcp build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvVlanPcpVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVlanPcp.Builder {
        final OFBsnTlvVlanPcpVer15 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvVlanPcpVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 72;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVlanPcp.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvVlanPcp build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvVlanPcpVer15(value);
        }
    }
}

