/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvParentPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvParentPortVer15
implements OFBsnTlvParentPort {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvParentPortVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFBsnTlvParentPortVer15 DEFAULT = new OFBsnTlvParentPortVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvParentPortVer15Funnel FUNNEL = new OFBsnTlvParentPortVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvParentPortVer15(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvParentPortVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 109;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvParentPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvParentPortVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvParentPortVer15 other = (OFBsnTlvParentPortVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvParentPortVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvParentPortVer15 message) {
            bb.writeShort(109);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvParentPortVer15Funnel
    implements Funnel<OFBsnTlvParentPortVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvParentPortVer15Funnel() {
        }

        public void funnel(OFBsnTlvParentPortVer15 message, PrimitiveSink sink) {
            sink.putShort((short)109);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvParentPort> {
        Reader() {
        }

        @Override
        public OFBsnTlvParentPort readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 109) {
                throw new OFParseError("Wrong type: Expected=0x6d(0x6d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFBsnTlvParentPortVer15 bsnTlvParentPortVer15 = new OFBsnTlvParentPortVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvParentPortVer15);
            }
            return bsnTlvParentPortVer15;
        }
    }

    static class Builder
    implements OFBsnTlvParentPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public int getType() {
            return 109;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvParentPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvParentPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvParentPortVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvParentPort.Builder {
        final OFBsnTlvParentPortVer15 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFBsnTlvParentPortVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 109;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvParentPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvParentPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvParentPortVer15(value);
        }
    }
}

