/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLoopbackMode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLoopbackMode;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLoopbackModeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLoopbackModeVer15
implements OFBsnTlvLoopbackMode {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLoopbackModeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final OFBsnLoopbackMode value;
    static final Reader READER = new Reader();
    static final OFBsnTlvLoopbackModeVer15Funnel FUNNEL = new OFBsnTlvLoopbackModeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLoopbackModeVer15(OFBsnLoopbackMode value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvLoopbackModeVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 146;
    }

    @Override
    public OFBsnLoopbackMode getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvLoopbackMode.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLoopbackModeVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLoopbackModeVer15 other = (OFBsnTlvLoopbackModeVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLoopbackModeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLoopbackModeVer15 message) {
            bb.writeShort(146);
            bb.writeShort(5);
            OFBsnLoopbackModeSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvLoopbackModeVer15Funnel
    implements Funnel<OFBsnTlvLoopbackModeVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLoopbackModeVer15Funnel() {
        }

        public void funnel(OFBsnTlvLoopbackModeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)146);
            sink.putShort((short)5);
            OFBsnLoopbackModeSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLoopbackMode> {
        Reader() {
        }

        @Override
        public OFBsnTlvLoopbackMode readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 146) {
                throw new OFParseError("Wrong type: Expected=0x92(0x92), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnLoopbackMode value = OFBsnLoopbackModeSerializerVer15.readFrom(bb);
            OFBsnTlvLoopbackModeVer15 bsnTlvLoopbackModeVer15 = new OFBsnTlvLoopbackModeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLoopbackModeVer15);
            }
            return bsnTlvLoopbackModeVer15;
        }
    }

    static class Builder
    implements OFBsnTlvLoopbackMode.Builder {
        private boolean valueSet;
        private OFBsnLoopbackMode value;

        Builder() {
        }

        @Override
        public int getType() {
            return 146;
        }

        @Override
        public OFBsnLoopbackMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLoopbackMode.Builder setValue(OFBsnLoopbackMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvLoopbackMode build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLoopbackModeVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLoopbackMode.Builder {
        final OFBsnTlvLoopbackModeVer15 parentMessage;
        private boolean valueSet;
        private OFBsnLoopbackMode value;

        BuilderWithParent(OFBsnTlvLoopbackModeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 146;
        }

        @Override
        public OFBsnLoopbackMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLoopbackMode.Builder setValue(OFBsnLoopbackMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvLoopbackMode build() {
            OFBsnLoopbackMode value;
            OFBsnLoopbackMode oFBsnLoopbackMode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLoopbackModeVer15(value);
        }
    }
}

