/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvL3;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvL3Ver15
implements OFBsnTlvL3 {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvL3Ver15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFBsnTlvL3Ver15 DEFAULT = new OFBsnTlvL3Ver15();
    static final OFBsnTlvL3Ver15 INSTANCE = new OFBsnTlvL3Ver15();
    static final Reader READER = new Reader();
    static final OFBsnTlvL3Ver15Funnel FUNNEL = new OFBsnTlvL3Ver15Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvL3Ver15() {
    }

    @Override
    public int getType() {
        return 168;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvL3.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvL3Ver15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvL3Ver15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvL3Ver15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvL3Ver15 message) {
            bb.writeShort(168);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvL3Ver15Funnel
    implements Funnel<OFBsnTlvL3Ver15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvL3Ver15Funnel() {
        }

        public void funnel(OFBsnTlvL3Ver15 message, PrimitiveSink sink) {
            sink.putShort((short)168);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvL3> {
        Reader() {
        }

        @Override
        public OFBsnTlvL3 readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 168) {
                throw new OFParseError("Wrong type: Expected=0xa8(0xa8), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

