/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashGtpHeaderMatch;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashGtpHeaderMatchVer15
implements OFBsnTlvHashGtpHeaderMatch {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashGtpHeaderMatchVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final short DEFAULT_FIRST_HEADER_BYTE = 0;
    private static final short DEFAULT_FIRST_HEADER_MASK = 0;
    private final short firstHeaderByte;
    private final short firstHeaderMask;
    static final OFBsnTlvHashGtpHeaderMatchVer15 DEFAULT = new OFBsnTlvHashGtpHeaderMatchVer15(0, 0);
    static final Reader READER = new Reader();
    static final OFBsnTlvHashGtpHeaderMatchVer15Funnel FUNNEL = new OFBsnTlvHashGtpHeaderMatchVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashGtpHeaderMatchVer15(short firstHeaderByte, short firstHeaderMask) {
        this.firstHeaderByte = firstHeaderByte;
        this.firstHeaderMask = firstHeaderMask;
    }

    @Override
    public int getType() {
        return 104;
    }

    @Override
    public short getFirstHeaderByte() {
        return this.firstHeaderByte;
    }

    @Override
    public short getFirstHeaderMask() {
        return this.firstHeaderMask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvHashGtpHeaderMatch.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashGtpHeaderMatchVer15(");
        b.append("firstHeaderByte=").append(this.firstHeaderByte);
        b.append(", ");
        b.append("firstHeaderMask=").append(this.firstHeaderMask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashGtpHeaderMatchVer15 other = (OFBsnTlvHashGtpHeaderMatchVer15)obj;
        if (this.firstHeaderByte != other.firstHeaderByte) {
            return false;
        }
        return this.firstHeaderMask == other.firstHeaderMask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.firstHeaderByte;
        result = 31 * result + this.firstHeaderMask;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashGtpHeaderMatchVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashGtpHeaderMatchVer15 message) {
            bb.writeShort(104);
            bb.writeShort(6);
            bb.writeByte((int)U8.t(message.firstHeaderByte));
            bb.writeByte((int)U8.t(message.firstHeaderMask));
        }
    }

    static class OFBsnTlvHashGtpHeaderMatchVer15Funnel
    implements Funnel<OFBsnTlvHashGtpHeaderMatchVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashGtpHeaderMatchVer15Funnel() {
        }

        public void funnel(OFBsnTlvHashGtpHeaderMatchVer15 message, PrimitiveSink sink) {
            sink.putShort((short)104);
            sink.putShort((short)6);
            sink.putShort(message.firstHeaderByte);
            sink.putShort(message.firstHeaderMask);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashGtpHeaderMatch> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 104) {
                throw new OFParseError("Wrong type: Expected=0x68(0x68), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short firstHeaderByte = U8.f(bb.readByte());
            short firstHeaderMask = U8.f(bb.readByte());
            OFBsnTlvHashGtpHeaderMatchVer15 bsnTlvHashGtpHeaderMatchVer15 = new OFBsnTlvHashGtpHeaderMatchVer15(firstHeaderByte, firstHeaderMask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashGtpHeaderMatchVer15);
            }
            return bsnTlvHashGtpHeaderMatchVer15;
        }
    }

    static class Builder
    implements OFBsnTlvHashGtpHeaderMatch.Builder {
        private boolean firstHeaderByteSet;
        private short firstHeaderByte;
        private boolean firstHeaderMaskSet;
        private short firstHeaderMask;

        Builder() {
        }

        @Override
        public int getType() {
            return 104;
        }

        @Override
        public short getFirstHeaderByte() {
            return this.firstHeaderByte;
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch.Builder setFirstHeaderByte(short firstHeaderByte) {
            this.firstHeaderByte = firstHeaderByte;
            this.firstHeaderByteSet = true;
            return this;
        }

        @Override
        public short getFirstHeaderMask() {
            return this.firstHeaderMask;
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch.Builder setFirstHeaderMask(short firstHeaderMask) {
            this.firstHeaderMask = firstHeaderMask;
            this.firstHeaderMaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch build() {
            short firstHeaderByte = this.firstHeaderByteSet ? this.firstHeaderByte : (short)0;
            short firstHeaderMask = this.firstHeaderMaskSet ? this.firstHeaderMask : (short)0;
            return new OFBsnTlvHashGtpHeaderMatchVer15(firstHeaderByte, firstHeaderMask);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashGtpHeaderMatch.Builder {
        final OFBsnTlvHashGtpHeaderMatchVer15 parentMessage;
        private boolean firstHeaderByteSet;
        private short firstHeaderByte;
        private boolean firstHeaderMaskSet;
        private short firstHeaderMask;

        BuilderWithParent(OFBsnTlvHashGtpHeaderMatchVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 104;
        }

        @Override
        public short getFirstHeaderByte() {
            return this.firstHeaderByte;
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch.Builder setFirstHeaderByte(short firstHeaderByte) {
            this.firstHeaderByte = firstHeaderByte;
            this.firstHeaderByteSet = true;
            return this;
        }

        @Override
        public short getFirstHeaderMask() {
            return this.firstHeaderMask;
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch.Builder setFirstHeaderMask(short firstHeaderMask) {
            this.firstHeaderMask = firstHeaderMask;
            this.firstHeaderMaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvHashGtpHeaderMatch build() {
            short firstHeaderByte = this.firstHeaderByteSet ? this.firstHeaderByte : this.parentMessage.firstHeaderByte;
            short firstHeaderMask = this.firstHeaderMaskSet ? this.firstHeaderMask : this.parentMessage.firstHeaderMask;
            return new OFBsnTlvHashGtpHeaderMatchVer15(firstHeaderByte, firstHeaderMask);
        }
    }
}

